package com.gaea.iesms.bm.alarm.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gaea.base.core.R;
import com.gaea.iesms.bm.alarm.mapper.CeSoeSortMapper;
import com.gaea.iesms.bm.alarm.model.response.dto.SoeSortDto;
import com.gaea.iesms.bm.alarm.model.request.AlarmSortPageRequest;
import com.gaea.iesms.bm.alarm.model.request.SoeSortRequest;
import com.gaea.iesms.bm.alarm.model.response.vo.SoeSortPageVo;
import com.gaea.iesms.bm.alarm.model.response.vo.SoeSortTreeVo;
import com.gaea.iesms.bm.alarm.model.response.vo.SoeSortVo;
import com.gaea.iesms.bm.alarm.service.CeSoeSortService;
import com.gaea.iesms.core.feign.dto.SysCodeSortDTO;
import com.gaea.iesms.core.feign.enums.SysCodeEnum;
import com.gaea.iesms.core.feign.enums.SysCodeProjectEnum;
import com.gaea.iesms.core.feign.request.SysCodeSortQueryRequest;
import com.gaea.iesms.core.feign.service.RemoteSystemService;
import com.gaea.iesms.core.model.entity.alarm.CeSoeSort;
import com.gaea.utils.ConvertUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
* @author Administrator
* @description 针对表【iesms_soe_sort(顺序事件分类;)】的数据库操作Service实现
* @createDate 2023-03-21 13:46:21
*/
@Service
public class CeSoeSortServiceImpl extends ServiceImpl<CeSoeSortMapper, CeSoeSort>
    implements CeSoeSortService {

    @Resource
    private CeSoeSortMapper ceSoeSortMapper;

    @Resource
    private RemoteSystemService remoteSystemService;

    @Override
    public CeSoeSort getSoeSortBySortNo(String soeSortNo) {
        QueryWrapper<CeSoeSort> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("soe_sort_no",soeSortNo);
        CeSoeSort ceSoeSort = this.baseMapper.selectOne(queryWrapper);
        return ceSoeSort;
    }

    /**
     * 告警类型分页查询
     * @param alarmSortPageRequest
     * @return
     */
    @Override
    public SoeSortPageVo listSoeSort(AlarmSortPageRequest alarmSortPageRequest)
    {
        Page<CeSoeSort> page = new Page<>(alarmSortPageRequest.getPageNumber(), alarmSortPageRequest.getPageSize());
        QueryWrapper<CeSoeSort> wrapper = new QueryWrapper<>();
        Page<CeSoeSort> ceSoeSortPage = baseMapper.selectPage(page, wrapper);
        List<CeSoeSort> records = ceSoeSortPage.getRecords();

        List<SoeSortVo> soeSortVoList = ConvertUtils.toList(SoeSortVo.class, records);
        SoeSortPageVo soeSortPageVo = new SoeSortPageVo();
        soeSortPageVo.setSoeSortList(soeSortVoList);
        soeSortPageVo.setTotal(ceSoeSortPage.getTotal());
        return soeSortPageVo;
    }

    @Override
    public SoeSortDto gerSoeSortInfoById(Long id) {
        CeSoeSort ceSoeSort = this.baseMapper.selectById(id);
        SoeSortDto soeSortDto = new SoeSortDto();
        BeanUtils.copyProperties(ceSoeSort,soeSortDto);
        return soeSortDto;
    }

    @Override
    public SoeSortDto gerSoeSortInfoBySortNo(String sortNo) {
        QueryWrapper<CeSoeSort> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("soe_sort_no",sortNo);
        CeSoeSort ceSoeSort = this.baseMapper.selectOne(queryWrapper);
        SoeSortDto soeSortDto = new SoeSortDto();
        BeanUtils.copyProperties(ceSoeSort,soeSortDto);
        return soeSortDto;
    }

    @Override
    public boolean addSoeSort(SoeSortRequest soeSortRequest) {
        CeSoeSort ceSoeSort = new CeSoeSort();
        BeanUtils.copyProperties(soeSortRequest,ceSoeSort);
        boolean flag = this.saveOrUpdate(ceSoeSort);
        return flag;
    }

    @Override
    public List<SoeSortDto> findAllSoeSort() {
        List<SoeSortDto>  soeSortDtoList = ceSoeSortMapper.findAllSoeSort();
        return soeSortDtoList;
    }

    @Override
    public List<SoeSortTreeVo> treeSoeSort(String sortBizProps) {
        List<SoeSortDto>  soeSortDtoList = ceSoeSortMapper.findSoeSortByBizProps(sortBizProps);

        Map<String, List<SoeSortDto>> soeSortClassList = soeSortDtoList.stream()
                .collect(Collectors.groupingBy(SoeSortDto::getSoeSortClass));
        SysCodeSortQueryRequest codeSortQueryRequest = new SysCodeSortQueryRequest();
        codeSortQueryRequest.setProjectCode(SysCodeProjectEnum.EMS_CODE.getValue());
        codeSortQueryRequest.setCodeSortNo(SysCodeEnum.SOE_SORT_CLASS_CODE.getValue());
        R<Map<String, SysCodeSortDTO>> codeSort = remoteSystemService.queryCodeSort(codeSortQueryRequest);
        Map<String, SysCodeSortDTO> codeSortMap = codeSort.getData();
        List<SoeSortTreeVo> soeSortTreeVoList = new ArrayList<>();
        if (codeSortMap.isEmpty()) {
            return soeSortTreeVoList;
        }
        for (Map.Entry<String, List<SoeSortDto>> sortClassEntry : soeSortClassList.entrySet()) {
            String sortNo = sortClassEntry.getKey();
            List<SoeSortDto> sortList = sortClassEntry.getValue();
            SoeSortTreeVo soeSortTreeVo = new SoeSortTreeVo();
            soeSortTreeVo.setSoeSortNo(sortNo);
            SysCodeSortDTO sysCodeSortDTO = codeSortMap.get(sortNo);
            soeSortTreeVo.setSoeSortName(sysCodeSortDTO.getCodeName());
            List<SoeSortTreeVo> soeSortList = ConvertUtils.toList(SoeSortTreeVo.class, sortList);
            soeSortTreeVo.setSeoList(soeSortList);
            soeSortTreeVoList.add(soeSortTreeVo);
        }
        return soeSortTreeVoList;
    }
}




