package com.gaea.iesms.bm.alarm.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.gaea.iesms.bm.alarm.mapper.SoeRecordMapper;
import com.gaea.iesms.bm.alarm.model.SoeRecordSaveDto;
import com.gaea.iesms.core.model.enums.alarm.SoeSortEnum;
import com.gaea.iesms.bm.alarm.service.EleAlarmService;
import com.gaea.iesms.bm.alarm.service.SoeRecordService;
import com.gaea.iesms.core.feign.request.alarm.EleAlarmRequest;
import com.gaea.iesms.core.feign.response.datacenter.MeasDataInsFreezeCurveValue;
import com.gaea.iesms.core.model.entity.alarm.SoeRecord;
import com.gaea.iesms.core.model.jsonobject.alarm.SoeGenValueJsonObject;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;

/**
 * @Author wangxiangzhong
 * @Description 电流告警
 * @Date 2023/05/04/10:32
 */
@Service
public class EleAlarmServiceImpl implements EleAlarmService {

    @Resource
    private SoeRecordMapper soeRecordMapper;

    @Resource
    private SoeRecordService soeRecordService;

    @Override
    public void eleUnBalanceAlarm(List<EleAlarmRequest> eleAlarmRequestList) {


        for (EleAlarmRequest eleAlarmRequest : eleAlarmRequestList) {
            int flag = soeRecordMapper.getRecordNotRecoveryCount(SoeSortEnum.SOE_DEV_DIST_INTERVAL_CURR_LOSSCURR_ALARM.getValue(), eleAlarmRequest.getDeviceId());
            if (flag <= 0) {
                List<List<MeasDataInsFreezeCurveValue>> threePhaseCurrentList = eleAlarmRequest.getThreePhaseCurrent();
                int count = 0;
                if (CollectionUtil.isNotEmpty(threePhaseCurrentList)) {
                    for (int i = 1; i < 4; i++) {
                        BigDecimal measValueia = threePhaseCurrentList.get(0).get(threePhaseCurrentList.get(0).size() - i).getMeasDataValue();
                        BigDecimal measValueib = threePhaseCurrentList.get(1).get(threePhaseCurrentList.get(1).size() - i).getMeasDataValue();
                        BigDecimal measValueic = threePhaseCurrentList.get(2).get(threePhaseCurrentList.get(2).size() - i).getMeasDataValue();

                        List<BigDecimal> paramsList = new ArrayList<>();
                        paramsList.add(measValueia);
                        paramsList.add(measValueib);
                        paramsList.add(measValueic);
                        //TODO 获取电流最大最小值
                        Map<String, BigDecimal> resultMap = this.getMaxAndMin(paramsList);
                        if (resultMap.get("max") != null && resultMap.get("max").compareTo(BigDecimal.ZERO) != 0) {
                            //TODO （三相电流最大值-最小值）/最大值 计算电流不平衡率K，判断是否越限。需先排除电流失流异常的情况。连续3个点。K为10%。
                            if (((resultMap.get("max").subtract(resultMap.get("min"))).divide(resultMap.get("max"), 2, RoundingMode.HALF_UP)).compareTo(BigDecimal.valueOf(0.1)) > 0) {
                                count++;
                            }
                        }
                    }
                    //custResource.setSoeSortNo("SOE_DEV_DIST_INTERVAL_CURR_IMBALANCE_ALARM");
                    //TODO count == 3 说明a，b，c三相全部越限
                    if (count == 3) {
                        //TODO SOE_DEV_DIST_INTERVAL_CURR_IMBALANCE_ALARM（间隔电流不平衡）
                        //TODO 查询告警表里面是否有记录
                        count = soeRecordMapper.getRecordNotRecoveryCount(SoeSortEnum.SOE_DEV_DIST_INTERVAL_CURR_IMBALANCE_ALARM.getValue(), eleAlarmRequest.getDeviceId() );
                        //TODO count<=0说明没记录 则插入一条间隔电流不平衡告警
                        if (count <= 0) {
                            SoeRecordSaveDto soeRecordSaveDto = new SoeRecordSaveDto();
                            soeRecordSaveDto.setOrgNo(eleAlarmRequest.getOrgNo());
                            soeRecordSaveDto.setSoeObjectId(eleAlarmRequest.getDeviceId());
                            soeRecordSaveDto.setSoeSortNo(SoeSortEnum.SOE_DEV_DIST_INTERVAL_CURR_IMBALANCE_ALARM.getValue());
                            soeRecordSaveDto.setSoeObjectName(eleAlarmRequest.getCeResName());
                            SoeGenValueJsonObject soeGenValueJsonObject = new SoeGenValueJsonObject();
                            soeGenValueJsonObject.setCeCustId(eleAlarmRequest .getCeCustId());
                            soeRecordSaveDto.setSoeGenValue(soeGenValueJsonObject);
                            soeRecordService.insertSoeRecordAndPushMq(soeRecordSaveDto);
                        }
                    } else {
                        //TODO 查看该逆变器是否存在电流越限告警  如果大于0 说明有跟新状态 复归掉 没有则不查
                        count = soeRecordMapper.getRecordNotRecoveryCount(SoeSortEnum.SOE_DEV_DIST_INTERVAL_CURR_IMBALANCE_ALARM.getValue(), eleAlarmRequest.getDeviceId() );
                        if (count > 0) {
                            //TODO 告警更新方法（复归掉）
                            SoeRecord recordDo = new SoeRecord();
                            recordDo.setSoeSortNo(SoeSortEnum.SOE_DEV_DIST_INTERVAL_CURR_IMBALANCE_ALARM.getValue());
                            recordDo.setSoeObjectId(eleAlarmRequest.getDeviceId());
                            recordDo.setGmtModified(System.currentTimeMillis());
                            recordDo.setIsRecovery(true);
                            recordDo.setModifier("sysadmin");
                            recordDo.setSoeRecTime(new Date());
                            soeRecordService.updateSoeRecord(recordDo);
                        }
                    }
                }
            }
        }

    }

    @Override
    public void eleErosionFlow(List<EleAlarmRequest> eleAlarmRequestList) {
        for (EleAlarmRequest eleAlarmRequest : eleAlarmRequestList) {
            List<List<MeasDataInsFreezeCurveValue>> threePhaseCurrent = eleAlarmRequest.getThreePhaseCurrent();// 电流
            List<List<MeasDataInsFreezeCurveValue>> threePhaseVoltage = eleAlarmRequest.getThreePhaseVoltage();// 电压
            int count = 0;
            for (int i = 1; i < 4; i++) {
                //TODO abc 三相电压
                BigDecimal measValuea = new BigDecimal("0.0");
                BigDecimal measValueb = new BigDecimal("0.0");
                BigDecimal measValuec = new BigDecimal("0.0");

                //TODO abc 三相电流
                BigDecimal measValueia = new BigDecimal("0.0");
                BigDecimal measValueib = new BigDecimal("0.0");
                BigDecimal measValueic = new BigDecimal("0.0");

                if (CollectionUtil.isNotEmpty(threePhaseVoltage)) {
                    measValuea = threePhaseVoltage.get(0).get(threePhaseVoltage.get(0).size() - i).getMeasDataValue();
                    measValueb = threePhaseVoltage.get(1).get(threePhaseVoltage.get(1).size() - i).getMeasDataValue();
                    measValuec = threePhaseVoltage.get(2).get(threePhaseVoltage.get(2).size() - i).getMeasDataValue();
                }
                if (CollectionUtil.isNotEmpty(threePhaseCurrent)) {
                    measValueia = threePhaseCurrent.get(0).get(threePhaseCurrent.get(0).size() - i).getMeasDataValue();
                    measValueib = threePhaseCurrent.get(1).get(threePhaseCurrent.get(1).size() - i).getMeasDataValue();
                    measValueic = threePhaseCurrent.get(2).get(threePhaseCurrent.get(2).size() - i).getMeasDataValue();
                }
                List<BigDecimal> paramsList = Lists.newArrayList();
                paramsList.add(measValueia);
                paramsList.add(measValueib);
                paramsList.add(measValueic);

                //TODO 如果连续三个点的任意一项电压在 0.7-0.9电压之间 才能判断电流失流告警
                if ((measValuea.compareTo(BigDecimal.valueOf(0.7 * 220)) >= 0 && measValuea.compareTo(BigDecimal.valueOf(0.9 * 220)) <= 0)
                        && (measValueb.compareTo(BigDecimal.valueOf(0.7 * 220)) >= 0 && measValueb.compareTo(BigDecimal.valueOf(0.9 * 220)) <= 0)
                        && (measValuec.compareTo(BigDecimal.valueOf(0.7 * 220)) >= 0 && measValuec.compareTo(BigDecimal.valueOf(0.9 * 220)) <= 0)) {
                    //TODO 判断电流是否失流
                    Map<String, Integer> resultMap = this.getEleCheckCount(paramsList);
                    //TODO 如果mincount 大于0 并且maxCount 大于0 那么count +1 (说明失流)
                    if (resultMap.get("minCount") > 0 && resultMap.get("maxCount") > 0) {
                        count++;
                    }
                }else {
                    return;
                }
            }

            if (count == 3) {
                count = soeRecordMapper.getRecordNotRecoveryCount(SoeSortEnum.SOE_DEV_DIST_INTERVAL_CURR_LOSSCURR_ALARM.getValue(), eleAlarmRequest.getDeviceId() );
                if (count <= 0) {
                    SoeRecordSaveDto soeRecordSaveDto = new SoeRecordSaveDto();
                    soeRecordSaveDto.setOrgNo(eleAlarmRequest.getOrgNo());
                    soeRecordSaveDto.setSoeObjectId(eleAlarmRequest.getDeviceId());
                    soeRecordSaveDto.setSoeSortNo(SoeSortEnum.SOE_DEV_DIST_INTERVAL_CURR_LOSSCURR_ALARM.getValue());
                    soeRecordSaveDto.setSoeObjectName(eleAlarmRequest.getCeResName());
                    SoeGenValueJsonObject soeGenValueJsonObject = new SoeGenValueJsonObject();
                    soeGenValueJsonObject.setCeCustId(eleAlarmRequest .getCeCustId());
                    soeRecordSaveDto.setSoeGenValue(soeGenValueJsonObject);
                    soeRecordService.insertSoeRecordAndPushMq(soeRecordSaveDto);
                }
            } else {
                count = soeRecordMapper.getRecordNotRecoveryCount(SoeSortEnum.SOE_DEV_DIST_INTERVAL_CURR_LOSSCURR_ALARM.getValue(), eleAlarmRequest.getDeviceId() );
                if (count > 0) {
                    SoeRecord recordDo = new SoeRecord();
                    recordDo.setSoeSortNo(SoeSortEnum.SOE_DEV_DIST_INTERVAL_CURR_LOSSCURR_ALARM.getValue());
                    recordDo.setSoeObjectId(eleAlarmRequest.getDeviceId());
                    recordDo.setGmtModified(System.currentTimeMillis());
                    recordDo.setIsRecovery(true);
                    recordDo.setModifier("sysadmin");
                    recordDo.setSoeRecTime(new Date());
                    soeRecordService.updateSoeRecord(recordDo);
                }
            }
        }
    }

    @Override
    public void eleOverCurrent(List<EleAlarmRequest> eleAlarmRequestList) {
        for (EleAlarmRequest eleAlarmRequest : eleAlarmRequestList) {
            List<List<MeasDataInsFreezeCurveValue>> threePhaseCurrentList = eleAlarmRequest.getThreePhaseCurrent();
            int count = 0;
            if (CollectionUtil.isNotEmpty(threePhaseCurrentList)) {
                for (int i = 1; i < 4; i++) {
                    BigDecimal measValueib = threePhaseCurrentList.get(1).get(threePhaseCurrentList.get(1).size() - i).getMeasDataValue();
                    BigDecimal measValueic = threePhaseCurrentList.get(2).get(threePhaseCurrentList.get(2).size() - i).getMeasDataValue();
                    BigDecimal measValueia = threePhaseCurrentList.get(0).get(threePhaseCurrentList.get(0).size() - i).getMeasDataValue();
                    //TODO 如果连续三个点的任意一项电流大于k*参比电流（100%*6） count+1
                    if ((measValueib.compareTo(BigDecimal.valueOf(6)) > 0 && measValueic.compareTo(BigDecimal.valueOf(6)) > 0)
                            && measValueia.compareTo(BigDecimal.valueOf(6)) > 0) {
                        count++;
                    }
                }
                //custResource.setSoeSortNo("SOE_DEV_DIST_INTERVAL_CURR_IMBALANCE_ALARM");
                //TODO count == 3 说明a，b，c三相全部越限
                if (count == 3) {
                    //TODO SOE_DEV_DIST_INTERVAL_CURR_IMBALANCE_ALARM（间隔电流不平衡）
                    //TODO 查询告警表里面是否有记录
                    count = soeRecordMapper.getRecordNotRecoveryCount(SoeSortEnum.SOE_DEV_DIST_INTERVAL_CURR_OUTLIMIT_ALARM.getValue(), eleAlarmRequest.getDeviceId() );
                    //TODO count<=0说明没记录 则插入一条间隔电流不平衡告警
                    if (count <= 0) {
                        SoeRecordSaveDto soeRecordSaveDto = new SoeRecordSaveDto();
                        soeRecordSaveDto.setOrgNo(eleAlarmRequest.getOrgNo());
                        soeRecordSaveDto.setSoeObjectId(eleAlarmRequest.getDeviceId());
                        soeRecordSaveDto.setSoeSortNo(SoeSortEnum.SOE_DEV_DIST_INTERVAL_CURR_OUTLIMIT_ALARM.getValue());
                        soeRecordSaveDto.setSoeObjectName(eleAlarmRequest.getCeResName());
                        soeRecordService.insertSoeRecordAndPushMq(soeRecordSaveDto);
                    }
                } else {
                    //TODO 查看该逆变器是否存在电流越限告警  如果大于0 说明有跟新状态 复归掉 没有则不查
                    count = soeRecordMapper.getRecordNotRecoveryCount(SoeSortEnum.SOE_DEV_DIST_INTERVAL_CURR_IMBALANCE_ALARM.getValue(), eleAlarmRequest.getDeviceId() );
                    if (count > 0) {
                        //TODO 告警更新方法（复归掉）
                        SoeRecord recordDo = new SoeRecord();
                        recordDo.setSoeSortNo(SoeSortEnum.SOE_DEV_DIST_INTERVAL_CURR_IMBALANCE_ALARM.getValue());
                        recordDo.setSoeObjectId(eleAlarmRequest.getDeviceId());
                        recordDo.setGmtModified(System.currentTimeMillis());
                        recordDo.setIsRecovery(true);
                        recordDo.setModifier("sysadmin");
                        recordDo.setSoeRecTime(new Date());
                        soeRecordService.updateSoeRecord(recordDo);
                    }
                }
            }
        }


    }

    /**
     * 获取最大最小值
     */
    private Map<String, BigDecimal> getMaxAndMin(List<BigDecimal> maxOrMinList) {
        BigDecimal max = maxOrMinList.get(0);
        BigDecimal min = maxOrMinList.get(0);
        Map<String, BigDecimal> maps = new HashMap<>();
        for (BigDecimal value : maxOrMinList) {
            if (min.compareTo(value) > 0) {
                min = value;
            }
            if (max.compareTo(value) < 0) {
                max = value;
            }
        }
        maps.put("max", max);
        maps.put("min", min);
        return maps;
    }


    /**
     * 判断电流是否失流
     */
    public Map<String, Integer> getEleCheckCount(List<BigDecimal> list) {
        Map<String, Integer> map = new HashMap<>();
        BigDecimal minValue = BigDecimal.valueOf(0.005 * 5);
        BigDecimal maxValue = BigDecimal.valueOf(0.1 * 5);
        int maxCount = 0;
        int minCount = 0;
        //TODO 任一相电流小于0.5%额定（基本）电流，另两相中至少一相电流不小于10%额定（基本）电流 也就是minCount>0 并且maxCount>0
        for (BigDecimal value : list) {
            //TODO 如果某相电流小于0.5%*5A minCount+1
            if (value.compareTo(minValue) < 0) {
                minCount++;
            }
            //TODO 如果某相电流大于等于10%*5A maxCount+1
            if (value.compareTo(maxValue) >= 0) {
                maxCount++;
            }
        }
        map.put("minCount", minCount);
        map.put("maxCount", maxCount);
        return map;
    }

}
