package com.gaea.iesms.bm.alarm.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.gaea.iesms.bm.alarm.mapper.SoeRecordMapper;
import com.gaea.iesms.bm.alarm.model.SoeRecordSaveDto;
import com.gaea.iesms.core.model.enums.alarm.SoeSortEnum;
import com.gaea.iesms.bm.alarm.service.InverterAlarmService;
import com.gaea.iesms.bm.alarm.service.SoeRecordService;
import com.gaea.iesms.core.feign.dto.MeasDataCumFreezeCurveValueDTO;
import com.gaea.iesms.core.feign.request.alarm.InverterAlarmRequest;
import com.gaea.iesms.core.feign.request.alarm.InverterTheBusTripAlarmRequest;
import com.gaea.iesms.core.feign.response.datacenter.MeasDataInsFreezeCurveValue;
import com.gaea.iesms.core.model.entity.alarm.SoeRecord;
import com.gaea.iesms.core.model.jsonobject.alarm.SoeGenValueJsonObject;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Author wangxiangzhong
 * @Description TODO
 * @Date 2023/05/05/9:17
 */
@Service
public class InverterAlarmServiceImpl implements InverterAlarmService {

    @Resource
    private SoeRecordMapper soeRecordMapper;


    @Resource
    private SoeRecordService soeRecordService;

    @Override
    public void inverterBranchCircuitAlarm(List<InverterAlarmRequest> inverterAlarmRequest) throws Exception {
        for (InverterAlarmRequest branchCircuitAlarm : inverterAlarmRequest) {
            int count = 0;
            //bmIesmsSoeSortMapper.getMeterSoeCount(map);


                List<MeasDataCumFreezeCurveValueDTO> curveValueList = branchCircuitAlarm.getCurveValueList();
            //TODO 如果连续三个点的 数据为0 那么生成一条告警
            if (curveValueList != null && curveValueList.size() > 3) {
                if (curveValueList.get(curveValueList.size() - 1).getMeasDataValue().compareTo(BigDecimal.ZERO) == 0
                        && curveValueList.get(curveValueList.size() - 2).getMeasDataValue().compareTo(BigDecimal.ZERO) == 0
                        && curveValueList.get(curveValueList.size() - 3).getMeasDataValue().compareTo(BigDecimal.ZERO) == 0
                ) {
                        //map.put("soeSortNo", alarmName);
                        //TODO 查看该汇流箱是否断路告警 如果有不管 没有新增
                        count = soeRecordMapper.getRecordNotRecoveryCount(branchCircuitAlarm.getSoeSortNo(),branchCircuitAlarm.getDeviceId());
                        if (count <= 0) {
                            SoeRecordSaveDto soeRecordSaveDto = new SoeRecordSaveDto();
                            soeRecordSaveDto.setSoeObjectId(branchCircuitAlarm.getDeviceId());
                            soeRecordSaveDto.setSoeSortNo(branchCircuitAlarm.getSoeSortNo());
                            soeRecordSaveDto.setOrgNo(branchCircuitAlarm.getOrgNo());
                            soeRecordSaveDto.setSoeObjectName(branchCircuitAlarm.getCeResName());
                            SoeGenValueJsonObject soeGenValueJsonObject = new SoeGenValueJsonObject();
                            soeGenValueJsonObject.setCeCustId(branchCircuitAlarm.getCeCustId());
                            soeRecordSaveDto.setSoeGenValue(soeGenValueJsonObject);
                            soeRecordService.insertSoeRecordAndPushMq(soeRecordSaveDto);
                        }
                    } else {
                        //TODO 查看该汇流箱是否断路告警  如果大于0 说明有 那么复归他
                        count = soeRecordMapper.getRecordNotRecoveryCount(branchCircuitAlarm.getSoeSortNo(),branchCircuitAlarm.getDeviceId());
                        if (count > 0) {
                            SoeRecord recordDo = new SoeRecord();
                            recordDo.setOrgNo(branchCircuitAlarm.getOrgNo());
                            recordDo.setSoeObjectType(1);
                            recordDo.setSoeSortNo(branchCircuitAlarm.getSoeSortNo());
                            recordDo.setSoeObjectId(branchCircuitAlarm.getDeviceId());
                            recordDo.setGmtModified(System.currentTimeMillis());
                            SoeGenValueJsonObject soeGenValueJsonObject = new SoeGenValueJsonObject();
                            soeGenValueJsonObject.setCeCustId(branchCircuitAlarm.getCeCustId());
                            recordDo.setSoeGenValue(soeGenValueJsonObject);
                            recordDo.setIsRecovery(true);
                            recordDo.setModifier("sysadmin");
                            recordDo.setSoeRecTime(new Date());
                            soeRecordService.updateSoeRecord(recordDo);
                        }

                    }

                }
        }
    }

    @Override
    public void inverterMpptCircuitAlarm(List<InverterAlarmRequest> inverterAlarmRequest) throws Exception {
        for (InverterAlarmRequest branchCircuitAlarm : inverterAlarmRequest) {
            int count = 0;
            //bmIesmsSoeSortMapper.getMeterSoeCount(map);
            List<MeasDataCumFreezeCurveValueDTO> curveValueList = branchCircuitAlarm.getCurveValueList();
            //TODO 如果连续三个点的 数据为0 那么生成一条告警
            if (curveValueList != null && curveValueList.size() > 3) {
                if (curveValueList.get(curveValueList.size() - 1).getMeasDataValue().compareTo(BigDecimal.ZERO) == 0
                        && curveValueList.get(curveValueList.size() - 2).getMeasDataValue().compareTo(BigDecimal.ZERO) == 0
                        && curveValueList.get(curveValueList.size() - 3).getMeasDataValue().compareTo(BigDecimal.ZERO) == 0
                ) {
                    //map.put("soeSortNo", alarmName);
                    //TODO 查看该汇流箱是否断路告警 如果有不管 没有新增
                    count = soeRecordMapper.getRecordNotRecoveryCount(branchCircuitAlarm.getSoeSortNo(),branchCircuitAlarm.getDeviceId());
                    if (count <= 0) {
                        SoeRecordSaveDto soeRecordSaveDto = new SoeRecordSaveDto();
                        soeRecordSaveDto.setSoeObjectId(branchCircuitAlarm.getDeviceId());
                        soeRecordSaveDto.setSoeSortNo(branchCircuitAlarm.getSoeSortNo());
                        soeRecordSaveDto.setOrgNo(branchCircuitAlarm.getOrgNo());
                        soeRecordSaveDto.setSoeObjectName(branchCircuitAlarm.getCeResName());
                        SoeGenValueJsonObject soeGenValueJsonObject = new SoeGenValueJsonObject();
                        soeGenValueJsonObject.setCeCustId(branchCircuitAlarm.getCeCustId());
                        soeRecordSaveDto.setSoeGenValue(soeGenValueJsonObject);
                        soeRecordService.insertSoeRecordAndPushMq(soeRecordSaveDto);
                    }
                } else {
                    //TODO 查看该汇流箱是否断路告警  如果大于0 说明有 那么复归他
                    count = soeRecordMapper.getRecordNotRecoveryCount(branchCircuitAlarm.getSoeSortNo(),branchCircuitAlarm.getDeviceId());
                    if (count > 0) {
                        SoeRecord recordDo = new SoeRecord();
                        recordDo.setOrgNo(branchCircuitAlarm.getOrgNo());
                        recordDo.setSoeObjectType(1);
                        recordDo.setSoeSortNo(branchCircuitAlarm.getSoeSortNo());
                        recordDo.setSoeObjectId(branchCircuitAlarm.getDeviceId());
                        recordDo.setGmtModified(System.currentTimeMillis());
                        SoeGenValueJsonObject soeGenValueJsonObject = new SoeGenValueJsonObject();
                        soeGenValueJsonObject.setCeCustId(branchCircuitAlarm.getCeCustId());
                        recordDo.setSoeGenValue(soeGenValueJsonObject);
                        recordDo.setIsRecovery(true);
                        recordDo.setModifier("sysadmin");
                        recordDo.setSoeRecTime(new Date());
                        soeRecordService.updateSoeRecord(recordDo);
                    }

                }

            }
        }
    }

    @Override
    public void inverterTheBusTripAlarm(List<InverterTheBusTripAlarmRequest> inverterTheBusTripAlarmRequestList) {
        for (InverterTheBusTripAlarmRequest inverterAlarmRequest : inverterTheBusTripAlarmRequestList) {
            List<MeasDataCumFreezeCurveValueDTO> curveValueList = inverterAlarmRequest.getCurveValueList();
            List<MeasDataInsFreezeCurveValue> insList = inverterAlarmRequest.getInsList();
            //TODO 一小时内最近的四个点值相同  那么生成一条告警
            if (CollectionUtil.isNotEmpty(curveValueList) && curveValueList.size() > 4) {
                if (curveValueList.get(curveValueList.size() - 1).getMeasDataValue().compareTo(curveValueList.get(curveValueList.size() - 2).getMeasDataValue()) == 0
                        && curveValueList.get(curveValueList.size() - 2).getMeasDataValue().compareTo(curveValueList.get(curveValueList.size() - 3).getMeasDataValue()) == 0
                        && curveValueList.get(curveValueList.size() - 3).getMeasDataValue().compareTo(curveValueList.get(curveValueList.size() - 4).getMeasDataValue()) == 0

                        && (insList == null || (insList.size() > 3 && insList.get(insList.size() - 1).getMeasDataValue().compareTo(BigDecimal.ZERO) == 0
                        && insList.get(insList.size() - 2).getMeasDataValue().compareTo(BigDecimal.ZERO) == 0
                        && insList.get(insList.size() - 3).getMeasDataValue().compareTo(BigDecimal.ZERO) == 0)
                )) {
                    //map.put("soeSortNo", "SOE_DEV_PV_INVERTER_BUS_TRIP_ALARM");
                    //TODO 查看该逆变器是否有总线跳闸告警  如果小于0 说明没有 新增一条告警
                    int count  = soeRecordMapper.getRecordNotRecoveryCount(SoeSortEnum.SOE_DEV_PV_INVERTER_BUS_TRIP_ALARM.getValue(),inverterAlarmRequest.getDeviceId());
                    if (count <= 0) {
                        SoeRecordSaveDto soeRecordSaveDto = new SoeRecordSaveDto();
                        soeRecordSaveDto.setSoeObjectId(inverterAlarmRequest.getDeviceId());
                        soeRecordSaveDto.setSoeSortNo(SoeSortEnum.SOE_DEV_PV_INVERTER_BUS_TRIP_ALARM.getValue());
                        soeRecordSaveDto.setOrgNo(inverterAlarmRequest.getOrgNo());
                        soeRecordSaveDto.setSoeObjectName(inverterAlarmRequest.getCeResName());
                        SoeGenValueJsonObject soeGenValueJsonObject = new SoeGenValueJsonObject();
                        soeGenValueJsonObject.setCeCustId(inverterAlarmRequest.getCeCustId());
                        soeRecordSaveDto.setSoeGenValue(soeGenValueJsonObject);
                        soeRecordService.insertSoeRecordAndPushMq(soeRecordSaveDto);
                    }
                } else {
                    //TODO 查看该逆变器是否有总线跳闸告警  如果小于0 说明没有 新增一条告警
                    int count  = soeRecordMapper.getRecordNotRecoveryCount(SoeSortEnum.SOE_DEV_PV_INVERTER_BUS_TRIP_ALARM.getValue(),inverterAlarmRequest.getDeviceId());
                    if (count > 0) {
                        SoeRecord recordDo = new SoeRecord();
                        recordDo.setOrgNo(inverterAlarmRequest.getOrgNo());
                        recordDo.setSoeObjectType(1);
                        recordDo.setSoeSortNo(SoeSortEnum.SOE_DEV_PV_INVERTER_BUS_TRIP_ALARM.getValue());
                        recordDo.setSoeObjectId(inverterAlarmRequest.getDeviceId());
                        recordDo.setGmtModified(System.currentTimeMillis());
                        SoeGenValueJsonObject soeGenValueJsonObject = new SoeGenValueJsonObject();
                        soeGenValueJsonObject.setCeCustId(inverterAlarmRequest.getCeCustId());
                        recordDo.setSoeGenValue(soeGenValueJsonObject);
                        recordDo.setIsRecovery(true);
                        recordDo.setModifier("sysadmin");
                        recordDo.setSoeRecTime(new Date());
                        soeRecordService.updateSoeRecord(recordDo);
//                        Map<String, Object> maps = new HashMap<>();
//                        maps.put("soeRecValue", "{}");
//                        SoeRecord recordDo = new SoeRecord();
//                        recordDo.setOrgNo(orgNo);
//                        recordDo.setSoeObjectType(20);
//                        recordDo.setSoeSortNo("SOE_DEV_PV_INVERTER_BUS_TRIP_ALARM");
//                        recordDo.setSoeObjectId(list.getId());
//                        recordDo.setGmtModified(System.currentTimeMillis());
//                        recordDo.setIsRecovery(true);
//                        recordDo.setModifier("sysadmin");
//                        recordDo.setSoeRecTime(new Date());
//                        recordDo.setSoeRecValue(Convert.convert(String.class, maps));
//                        updateSoeRecord(recordDo);
                    }
                }

            }
        }

    }

}
