package com.gaea.iesms.bm.alarm.service.impl;

import com.gaea.iesms.bm.alarm.mapper.SoeRecordMapper;
import com.gaea.iesms.bm.alarm.model.SoeRecordSaveDto;
import com.gaea.iesms.core.model.enums.alarm.SoeSortEnum;
import com.gaea.iesms.bm.alarm.service.CeSoeSortService;
import com.gaea.iesms.bm.alarm.service.MeterAlarmService;
import com.gaea.iesms.bm.alarm.service.SoeRecordService;
import com.gaea.iesms.core.feign.request.alarm.MeterCollAlarmRequest;
import com.gaea.iesms.core.model.entity.alarm.CeSoeSort;
import com.gaea.iesms.core.model.entity.alarm.SoeRecord;
import com.gaea.iesms.core.model.jsonobject.alarm.SoeGenValueJsonObject;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * @Author wangxiangzhong
 * @Description 表计告警
 * @Date 2023/05/05/9:57
 */
@Service
public class MeterAlarmServiceImpl implements MeterAlarmService {
    @Resource
    private SoeRecordMapper soeRecordMapper;

    @Resource
    private CeSoeSortService ceSoeSortService;

    @Resource
    private SoeRecordService soeRecordService;

    @Override
    public void meterCollAlarm(List<MeterCollAlarmRequest> meterCollAlarmRequestList){
        //TODO 获取当前时间的时间戳
        long now = System.currentTimeMillis();
        //TODO 获取一个小时的时间戳
        long dates = 75 * 60 * 1000;
        String sortNo = SoeSortEnum.SOE_METER_GATHER_FAILURE.getValue();
        for (MeterCollAlarmRequest meterCollAlarmRequest : meterCollAlarmRequestList) {
            if (now - meterCollAlarmRequest.getTermGmopsGmtMessageUp() <= dates) {
                //TODO 如果表计在线数为0 的话 说明有故障了
                int count;

                //TODO 判断告警表里是否有此表计的告警记录（未复归告警） 如有，则复归此告警 如无，则不作任何操作
                count = soeRecordMapper.getRecordNotRecoveryCount(sortNo,meterCollAlarmRequest.getMeterId());
                //TODO 判断表计通讯是否正常（1小时）
                if (now - meterCollAlarmRequest.getMeterFaultGmtMessageUp() <= dates && meterCollAlarmRequest.getMeterFaultGmtMessageUp() > 0) {
                    if (count > 0) {
                        CeSoeSort soeSortBySortNo = ceSoeSortService.getSoeSortBySortNo(sortNo);
                        //TODO 如果count>0 那么将其复归
                        //maps.put("soeRecValue", "{}");
                        SoeRecord recordDo = new SoeRecord();
                        recordDo.setOrgNo(meterCollAlarmRequest.getOrgNo());
                        recordDo.setSoeObjectType(soeSortBySortNo.getSoeObjectType());
                        recordDo.setSoeSortNo(sortNo);
                        recordDo.setSoeObjectId(meterCollAlarmRequest.getMeterId());
                        recordDo.setIsRecovery(true);
                        recordDo.setSoeRecTime(new Date());
                        SoeGenValueJsonObject soeGenValueJsonObject = new SoeGenValueJsonObject();
                        soeGenValueJsonObject.setCeCustId(meterCollAlarmRequest.getCeCustId());
                        recordDo.setSoeGenValue(soeGenValueJsonObject);
                        soeRecordService.updateSoeRecord(recordDo);
//                                        System.out.println("表计" + recordVo.getId() + "已复归");
                    }
                } else {
                    //TODO 如果表计通讯不正常 判断告警表里是否有此表计的告警
                    if (count <= 0) {
                        //TODO 如无，则插入此表计通讯故障告警
                        SoeRecordSaveDto soeRecordSaveDto = new SoeRecordSaveDto();
                        soeRecordSaveDto.setSoeObjectId(meterCollAlarmRequest.getMeterId());
                        soeRecordSaveDto.setSoeSortNo(sortNo);
                        soeRecordSaveDto.setOrgNo(meterCollAlarmRequest.getOrgNo());
                        soeRecordSaveDto.setSoeObjectName(meterCollAlarmRequest.getDevTermName());
                        SoeGenValueJsonObject soeGenValueJsonObject = new SoeGenValueJsonObject();
                        soeGenValueJsonObject.setCeCustId(meterCollAlarmRequest.getCeCustId());
                        soeRecordSaveDto.setSoeGenValue(soeGenValueJsonObject);
                        soeRecordService.insertSoeRecordAndPushMq(soeRecordSaveDto);
//                                        System.out.println("表计" + recordVo.getId() + "离线");
                    }
                }
            }
        }

    }
}
