package com.gaea.iesms.bm.alarm.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gaea.base.core.R;
import com.gaea.iesms.bm.alarm.mapper.OpsSubsInfoOrgMapper;
import com.gaea.iesms.bm.alarm.model.request.AddSubsInfoRequest;
import com.gaea.iesms.bm.alarm.model.request.SubsInfoPageRequest;
import com.gaea.iesms.bm.alarm.model.request.UpdateSubsInfoRequest;
import com.gaea.iesms.bm.alarm.model.response.dto.SoeSortDto;
import com.gaea.iesms.bm.alarm.model.response.vo.OpsSubsInfoPageVo;
import com.gaea.iesms.bm.alarm.model.response.vo.OpsSubsInfoVo;
import com.gaea.iesms.bm.alarm.service.CeSoeSortService;
import com.gaea.iesms.bm.alarm.service.OpsSubsInfoOrgService;
import com.gaea.iesms.core.model.entity.alarm.CeSoeSort;
import com.gaea.iesms.core.model.entity.alarm.OpsSubsInfoOrg;
import com.gaea.iesms.core.model.jsonobject.alarm.MobileSmsNtfyConfigJsonObject;
import com.gaea.iesms.core.model.jsonobject.alarm.MobileVoiceNtfyConfigJsonObject;
import com.gaea.iesms.core.model.jsonobject.alarm.SoeFilterConfigJsonObject;
import com.gaea.iesms.core.model.jsonobject.alarm.SysBellAlarmConfigJsonObject;
import com.gaea.spring.cloud.starter.util.AuthUtils;
import com.gaea.spring.cloud.starter.vo.UserDetail;
import com.gaea.utils.ConvertUtils;
import com.gaea.utils.StringUtils;
import com.google.common.collect.Maps;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
* @author wangxiangzhong
* @description 针对表【ops_subs_info_cecust(告警订阅信息（用能客户） )】的数据库操作Service实现
* @createDate 2023-03-24 17:02:35
*/
@Service
public class OpsSubsInfoOrgServiceImpl extends ServiceImpl<OpsSubsInfoOrgMapper, OpsSubsInfoOrg>
    implements OpsSubsInfoOrgService {


    @Resource
    private CeSoeSortService ceSoeSortService;

    @Override
    public int addOpsSubsInfo(AddSubsInfoRequest addSubsInfoRequest) {
        OpsSubsInfoOrg opsSubsInfoOrg = new OpsSubsInfoOrg();
        BeanUtils.copyProperties(addSubsInfoRequest, opsSubsInfoOrg);
        String userNo = AuthUtils.getUserDetail().getUserNo();
        opsSubsInfoOrg.setOrgNo(AuthUtils.getOrgNo());
        SysBellAlarmConfigJsonObject sysBellAlarmConfig = new SysBellAlarmConfigJsonObject();
        sysBellAlarmConfig.setSeriousAlarmBellUrl(addSubsInfoRequest.getSeriousAlarmBellUrl());
        sysBellAlarmConfig.setGeneralAlarmBellUrl(addSubsInfoRequest.getGeneralAlarmBellUrl());
        sysBellAlarmConfig.setSlightAlarmBellUrl(addSubsInfoRequest.getSlightAlarmBellUrl());
        opsSubsInfoOrg.setSysBellAlarmConfig(sysBellAlarmConfig);
//        mapVoice.put("serious_alarm_bell_url", opsSubsInfoOrg.getSerious_alarm_bell_url());
//        mapVoice.put("general_alarm_bell_url", opsSubsInfoOrg.getGeneral_alarm_bell_url());
//        mapVoice.put("slight_alarm_bell_url", opsSubsInfoOrg.getSlight_alarm_bell_url());
//        opsSubsInfoOrg.setSysBellAlarmConfig(JsonConvertUtils.convertToString(mapVoice));

        MobileSmsNtfyConfigJsonObject smsNtfyConfigJsonObject = new MobileSmsNtfyConfigJsonObject();
        smsNtfyConfigJsonObject.setMobileListStr(addSubsInfoRequest.getMobileSmsNtfyConfig());
        opsSubsInfoOrg.setMobileSmsNtfyConfig(smsNtfyConfigJsonObject);
//        Map<String, Object> mapSms = Maps.newHashMap();
//        mapSms.put("mobile_list_str", opsSubsInfoOrg.getMobileSmsNtfyConfig());
//        opsSubsInfoOrg.setMobileSmsNtfyConfig(JsonConvertUtils.convertToString(mapSms));

        MobileVoiceNtfyConfigJsonObject mobileVoiceNtfyConfig = new MobileVoiceNtfyConfigJsonObject();
        mobileVoiceNtfyConfig.setMobileListStr(addSubsInfoRequest.getMobileVoiceNtfyConfig());
        opsSubsInfoOrg.setMobileVoiceNtfyConfig(mobileVoiceNtfyConfig);
//        Map<String, Object> mapMobileVoice = Maps.newHashMap();
//        mapMobileVoice.put("mobile_list_str", opsSubsInfoOrg.getMobileVoiceNtfyConfig());
//        opsSubsInfoOrg.setMobileVoiceNtfyConfig(JsonConvertUtils.convertToString(mapMobileVoice));
        SoeFilterConfigJsonObject soeFilterConfig = new SoeFilterConfigJsonObject();
        soeFilterConfig.setSoeFilterType(addSubsInfoRequest.getSoeFilterType());
        soeFilterConfig.setSoeSortNoList(addSubsInfoRequest.getSoeSortNoList());
        opsSubsInfoOrg.setSoeFilterConfig(soeFilterConfig);
//        Map<String, Object> mapsoeFilterType = Maps.newHashMap();
//        mapsoeFilterType.put("soe_filter_type", opsSubsInfoOrg.getSoe_filter_type());
//        mapsoeFilterType.put("soe_sort_no_list", opsSubsInfoOrg.getSoe_sort_no_list());
//        opsSubsInfoOrg.setSoeFilterConfig(JsonConvertUtils.convertToString(mapsoeFilterType));
//
//
          opsSubsInfoOrg.setCreator(userNo);
          opsSubsInfoOrg.setModifier(userNo);
          opsSubsInfoOrg.setInvalider(userNo);

          Integer flag = this.baseMapper.insert(opsSubsInfoOrg);

//        Integer flag = null;
//        if (opsSubsInfoOrg.getCeCustId() != null) {
//            flag = alarmManageService.addSubsInfo(opsSubsInfoOrg);
//        } else {
//            for (String ceCustId : opsSubsInfoOrg.getCeCustIds()) {
//                opsSubsInfoOrg.setCeCustId(Long.valueOf(ceCustId));
//                flag = alarmManageService.addSubsInfo(opsSubsInfoOrg);
//            }
//        }
//
        return flag;
    }

    @Override
    public OpsSubsInfoPageVo listSubscribe(SubsInfoPageRequest subsInfoPageRequest) {

        Page<OpsSubsInfoOrg> page = new Page<>(subsInfoPageRequest.getPageNumber(), subsInfoPageRequest.getPageSize());
        QueryWrapper<OpsSubsInfoOrg> wrapper = new QueryWrapper<>();
        UserDetail userDetail = AuthUtils.getUserDetail();
        String orgNo = userDetail.getOrgNo();
        wrapper.eq("org_no",orgNo);
        wrapper.eq("is_valid",1);
        Page<OpsSubsInfoOrg> subsInfoOrgPage = baseMapper.selectPage(page, wrapper);
        List<OpsSubsInfoOrg> records = subsInfoOrgPage.getRecords();
        List<OpsSubsInfoVo> opsSubsInfoVos = ConvertUtils.toList(OpsSubsInfoVo.class, records);

       List<SoeSortDto> ceSoeSortList =  ceSoeSortService.findAllSoeSort();
        for (OpsSubsInfoVo item : opsSubsInfoVos) {
            if (item.getSoeFilterConfig() != null) {
                List<String> soeListAll = new ArrayList<>();
                List<String> soeSortNoList = item.getSoeFilterConfig().getSoeSortNoList();
                for (String soe : soeSortNoList) {
                    for (SoeSortDto soeSort : ceSoeSortList) {
                        if (!StringUtils.isEmpty(soe)) {
                            soeListAll.add(soeSort.getSoeSortName());
                        }
                    }
                }
                String filterType = item.getSoeFilterConfig().getSoeFilterType();
                if (filterType.equals("all")) {
                    for (SoeSortDto soeSort : ceSoeSortList) {
                        soeListAll.add(soeSort.getSoeSortName());
                    }
                }
                item.setSortNameList(soeListAll);
            }
        }
        OpsSubsInfoPageVo opsSubsInfoPageVo = new OpsSubsInfoPageVo();
        opsSubsInfoPageVo.setOpsSubsInfoVo(opsSubsInfoVos);
        opsSubsInfoPageVo.setTotal(subsInfoOrgPage.getTotal());
        return opsSubsInfoPageVo;
    }

    @Override
    public R updateSubscribe(UpdateSubsInfoRequest updateSubsInfoRequest) {

        OpsSubsInfoOrg opsSubsInfoOrg = this.baseMapper.selectById(updateSubsInfoRequest.getId());
        // 告警铃声
        SysBellAlarmConfigJsonObject sysBellAlarmConfig = new SysBellAlarmConfigJsonObject();
        sysBellAlarmConfig.setSeriousAlarmBellUrl(updateSubsInfoRequest.getSeriousAlarmBellUrl());
        sysBellAlarmConfig.setGeneralAlarmBellUrl(updateSubsInfoRequest.getGeneralAlarmBellUrl());
        sysBellAlarmConfig.setSlightAlarmBellUrl(updateSubsInfoRequest.getSlightAlarmBellUrl());
        opsSubsInfoOrg.setSysBellAlarmConfig(sysBellAlarmConfig);
        opsSubsInfoOrg.setSysBellAlarm(updateSubsInfoRequest.isSysBellAlarm());
        // 告警铃声
        MobileSmsNtfyConfigJsonObject smsNtfyConfigJsonObject = new MobileSmsNtfyConfigJsonObject();
        smsNtfyConfigJsonObject.setMobileListStr(updateSubsInfoRequest.getMobileSmsNtfyConfig());
        opsSubsInfoOrg.setMobileSmsNtfyConfig(smsNtfyConfigJsonObject);
        opsSubsInfoOrg.setMobileSmsNtfy(updateSubsInfoRequest.isMobileSmsNtfy());

        MobileVoiceNtfyConfigJsonObject mobileVoiceNtfyConfig = new MobileVoiceNtfyConfigJsonObject();
        mobileVoiceNtfyConfig.setMobileListStr(updateSubsInfoRequest.getMobileVoiceNtfyConfig());
        opsSubsInfoOrg.setMobileVoiceNtfyConfig(mobileVoiceNtfyConfig);
        opsSubsInfoOrg.setMobileVoiceNtfy(updateSubsInfoRequest.isMobileVoiceNtfy());

        SoeFilterConfigJsonObject soeFilterConfig = new SoeFilterConfigJsonObject();
        soeFilterConfig.setSoeFilterType(updateSubsInfoRequest.getSoeFilterType());
        soeFilterConfig.setSoeSortNoList(updateSubsInfoRequest.getSoeSortNoList());
        opsSubsInfoOrg.setSoeFilterConfig(soeFilterConfig);
        this.updateById(opsSubsInfoOrg);
        return R.ok();
    }

    @Override
    public R delSubsInfo(List<String> ids) {
        this.baseMapper.deleteBatchIds(ids);
        return R.ok();
    }
}




