package com.gaea.iesms.bm.archive;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/11/22
 */
@EnableDiscoveryClient
@EnableFeignClients(basePackages = "com.gaea.iesms.core.feign.**")
@SpringBootApplication(scanBasePackages = {"com.gaea.iesms.bm.archive.**", "com.gaea.spring.cloud.starter.**"})
public class ArchiveStarter {

    public static void main(final String... args) {
        try {
            SpringApplication.run(ArchiveStarter.class, args);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
