package com.gaea.iesms.bm.archive.config;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.jdbc.core.JdbcTemplate;

import javax.sql.DataSource;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2022/5/10
 */
@Configuration
@Order(Ordered.HIGHEST_PRECEDENCE + 1)
@SuppressWarnings("all")
public class ArchiveJdbcTemplateConfig {

    @Bean(name = "archiveJdbcTemplate")
    @Qualifier("archiveJdbcTemplate")
    @Primary
    JdbcTemplate cbikeJdbcTemplate(@Qualifier("archiveDataSource") DataSource emsDataSource) {
        return new JdbcTemplate(emsDataSource);
    }
}
