package com.gaea.iesms.bm.archive.controller;

import com.gaea.base.core.R;
import com.gaea.base.enums.HandleCodeEnum;
import com.gaea.iesms.bm.archive.model.request.cePoint.CePointPageRequest;
import com.gaea.iesms.bm.archive.model.request.cePoint.CePointRequest;
import com.gaea.iesms.bm.archive.model.response.dto.CePoint.CePointDto;
import com.gaea.iesms.bm.archive.model.response.dto.CePoint.CePointPageDto;
import com.gaea.iesms.bm.archive.model.response.vo.CePoint.CePointPageVo;
import com.gaea.iesms.bm.archive.model.response.vo.CePoint.CePointVo;
import com.gaea.iesms.bm.archive.service.CePointService;
import com.gaea.iesms.core.model.entity.archive.CePoint;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Administrator
 * @version 1.0
 * @description: 用能点信息管理
 * @date 2023/3/23 11:48
 */
@Api(tags = "用能点信息管理")
@RestController
@RequestMapping("/cePoint")
public class CePointController {


    @Resource
    private CePointService cePointService;

    /**
     * 添加用能点
     *
     * @param cePointRequest 用能点信息
     * @return ResponseData
     */
    @PostMapping("/addCePoint")
    @ApiOperation(value = "添加用能点")
    public R addCePoint(@RequestBody CePointRequest cePointRequest) {
        CePoint cePoint = new CePoint();
        BeanUtils.copyProperties(cePointRequest, cePoint);
        boolean save = cePointService.save(cePoint);
        if (save) {
            return R.enums(HandleCodeEnum.INSERT_SUCCESS);
        }
        return R.enums(HandleCodeEnum.INSERT_ERROR);
    }

    /**
     * 修改用能点
     *
     * @param cePointRequest 用能点信息
     * @return ResponseData
     */
    @PutMapping("/updateCePoint")
    @ApiOperation(value = "修改用能点")
    public R updateCePoint(@RequestBody CePointRequest cePointRequest) {
        CePoint cePoint = cePointService.getById(cePointRequest.getId());
        if (cePoint == null) {
            return R.enums(HandleCodeEnum.SELECT_ERROR);
        }
        BeanUtils.copyProperties(cePointRequest, cePoint);
        boolean update = cePointService.updateById(cePoint);
        if (update) {
            return R.enums(HandleCodeEnum.MODIFY_SUCCESS);
        }
        return R.enums(HandleCodeEnum.MODIFY_ERROR);
    }

    /**
     * 根据用能点id删除用能点
     *
     * @param id 用能点id
     * @return 是否删除成功
     */
    @DeleteMapping("/deleteCePointById")
    @ApiOperation(value = "根据用能点id删除用能点")
    public R deleteCePointById(Long id) {
        boolean deleted = cePointService.removeById(id);
        if (deleted) {
            return R.enums(HandleCodeEnum.DELETE_SUCCESS);
        } else {
            return R.enums(HandleCodeEnum.DELETE_ERROR);
        }
    }

    /**
     * 查询单个用能点
     *
     * @param id 用能点ID
     * @return ResponseData
     */
    @ApiParam(name = "id", value = "用能点ID", required = true)
    @GetMapping("/getCePoint")
    @ApiOperation(value = "查询单个用能点")
    public R<CePointVo> getCePoint(Long id) {
        CePoint cePoint = cePointService.getById(id);
        CePointVo cePointVo = new CePointVo();
        if (cePoint != null) {
            BeanUtils.copyProperties(cePoint, cePointVo);
            return R.ok(cePointVo);
        }
        return R.enums(HandleCodeEnum.SELECT_ERROR);
    }

    /**
     * 查询所有用能点
     *
     * @return ResponseData
     */
    @GetMapping("/getAllCePoints")
    @ApiOperation(value = "查询所有用能点")
    public R<List<CePointVo>> getAllCePoints() {
        List<CePoint> cePoints = cePointService.list();
        List<CePointVo> cePointVos = new ArrayList<>();
        for (CePoint cePoint : cePoints) {
            CePointVo cePointVo = new CePointVo();
            BeanUtils.copyProperties(cePoint, cePointVo);
            cePointVos.add(cePointVo);
        }
        return R.ok(cePointVos);
    }

    /**
     * 分页查询所有用能点
     *
     * @param cePointPageRequest 查询参数
     * @return ResponseData
     */
    @GetMapping("/cePointList")
    @ApiOperation(value = "分页查询所有用能点")
    public R<CePointPageVo> getCePointList(CePointPageRequest cePointPageRequest) {
        CePointPageDto cePointPageDto = cePointService.getCePointList(cePointPageRequest);
        CePointPageVo cePointPageVo = new CePointPageVo();
        List<CePointVo> cePointVoList = new ArrayList<>();
        for (CePointDto cePointDto : cePointPageDto.getCePointDtoList()) {
            CePointVo cePointVo = new CePointVo();
            BeanUtils.copyProperties(cePointDto, cePointVo);
            cePointVoList.add(cePointVo);
        }
        cePointPageVo.setCePointVoList(cePointVoList);
        cePointPageVo.setTotal(cePointPageDto.getTotal());
        return R.ok(cePointPageVo);
    }
}
