package com.gaea.iesms.bm.archive.controller;

import com.gaea.base.core.R;
import com.gaea.iesms.bm.archive.service.CePointMeterService;
import com.gaea.iesms.core.feign.dto.DevMeterIdAndCeResIdDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 用能点量测表计关系
 *
 * @author JIE
 * @version 1.0
 * @date 2024/3/29 14:33
 */
@Api(tags = "用能点量测表计关系")
@RestController
@RequestMapping("/cePointMeter")
public class CePointMeterController {

    @Resource
    private CePointMeterService cePointMeterService;

    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "ceResIds", value = "用能资源ID集合", required = true, dataType = "List<Long>", paramType = "query")
    })
    @ApiOperation(value = "根据用能资源Id 获取量测表计ID集合")
    @GetMapping("getDevMeterIdListByCeResIds")
    public R<List<DevMeterIdAndCeResIdDto>> getDevMeterIdListByCeResIds(@RequestParam("ceResIds") List<Long> ceResIds) {
        return R.ok(cePointMeterService.getDevMeterIdListByCeResIds(ceResIds));
    }
}
