package com.gaea.iesms.bm.archive.model.request.ceContainer;

import com.gaea.iesms.bm.archive.model.ContainerData;
import lombok.Data;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Administrator
 * @version 1.0
 * @description: 光伏/风电 发电站请求类
 * @date 2023/5/4 11:53
 */
@Data
public class PowerStationRequest extends ContainerData {

    /**
     * 装机容量
     */
    private String installCapacity;

    /**
     * 并网类型
     */
    private Integer pvNetType;

    /**
     * 并网电压等级
     */
    private String pvVolatageClass;

    /**
     * 并网对象
     */
    private String pvNetObj;

    /**
     * 立户日期
     */
    private String custDate;

    /**
     * 投运日期
     */
    private String parallelDate;

    @Override
    public void setProperties(Map<String, Object> properties) {
        this.installCapacity = (String) properties.get("installCapacity");
        this.pvNetType = (Integer) properties.get("pvNetType");
        this.pvVolatageClass = (String) properties.get("pvVolatageClass");
        this.pvNetObj = (String) properties.get("pvNetObj");
        this.custDate = (String) properties.get("custDate");
        this.parallelDate = (String) properties.get("parallelDate");
    }

    @Override
    public Map<String, Object> getProperties() {
        Map<String, Object> properties = new HashMap<>();
        properties.put("installCapacity", installCapacity);
        properties.put("pvNetType", pvNetType);
        properties.put("pvVolatageClass", pvVolatageClass);
        properties.put("pvNetObj", pvNetObj);
        properties.put("custDate", custDate);
        properties.put("parallelDate", parallelDate);
        return properties;
    }
}
