package com.gaea.iesms.bm.archive.model.request.ceContainer;

import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 修改用能容器请求类
 *
 * @author JIE
 * @version 1.0
 * @date 2024/1/31 14:50
 */
@ApiModel("修改用能容器请求类")
@Data
public class UpdateCeContainerRequest {

    @NotBlank(message = "主键ID不能为空")
    @ApiModelProperty("主键ID")
    private String id;

    /**
     * 用能资源（容器）分类编号 见用能资源分类表
     */
    @NotBlank(message = "用能资源（容器）分类编号不能为空")
    @ApiModelProperty(value = "用能资源（容器）分类编号")
    private String ceResSortNo;

    /**
     * 用能容器属性集
     */
    @ApiModelProperty(value = "用能容器属性集")
    private JsonNode ceResourceProps;
}
