package com.gaea.iesms.bm.archive.model.request.cePart;

import com.fasterxml.jackson.databind.JsonNode;
import com.gaea.iesms.core.feign.request.archive.CeResourceRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 用能区域 用能资源子表
 *
 * @author 用能区域基础请求类
 * @TableName ce_part
 */
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "用能区域基础请求类")
@Data
public class CePartRequest extends CeResourceRequest {

    /**
     * 用能资源（区域）分类编号 见用能资源分类表
     */
    @ApiModelProperty(value = "用能资源（区域）分类编号 见用能资源分类表")
    private String ceResSortNo;

    /**
     * 用能资源（区域）分类编号 见用能资源分类表
     */
    @ApiModelProperty(value = "用能资源分类编号id")
    private String ceResSortNoId;

    /**
     * 上级ID
     */
    @ApiModelProperty(value = "上级ID")
    private Long parentCeResId;

    /**
     * 用能区域面积
     */
    @ApiModelProperty(value = "用能区域面积")
    private BigDecimal cePartArea;

    /**
     * 用能区域属性集
     */
    @ApiModelProperty(value = "用能区域属性集")
    private JsonNode ceResourceProps;
}