package com.gaea.iesms.bm.archive.model.request.cePoint;

import com.gaea.iesms.core.model.jsonobject.archive.CePointPropsJsonObject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author Jie
 */
@Data
@ApiModel(description = "用能点D请求类，用于在前端和控制层交互的数据传输对象")
public class CePointRequest {

    @ApiModelProperty(value = "用能点标识")
    private Long id;

    @ApiModelProperty(value = "系统单位编号")
    private String orgNo;

    @ApiModelProperty(value = "用能点编号")
    private String cePointNo;

    @ApiModelProperty(value = "用能客户标识")
    private Long ceCustId;

    @ApiModelProperty(value = "用能资源标识")
    private Long ceResId;

    @ApiModelProperty(value = "用能资源类别，1 - 用能客户；2 - 用能区域；3 - 用能容器；4 - 用能设备")
    private Integer ceResClass;

    @ApiModelProperty(value = "用能点名称")
    private String cePointName;

    @ApiModelProperty(value = "用能点分类，1 – 用电；2 – 用水；3 – 用气；4 – 用热；5 - 用汽")
    private Integer cePointSort;

    @ApiModelProperty(value = "是否结算，0 - 否；1 - 是")
    private Integer isSettlement;

    @ApiModelProperty(value = "用能点层级")
    private Integer cePointLevel;

    @ApiModelProperty(value = "上级用能点标识")
    private Long parentId;

    @ApiModelProperty(value = "量测点集合")
    private List<Long> measPointIdList;

    @ApiModelProperty(value = "量测计算公式")
    private String measCalcRule;

    @ApiModelProperty(value = "用能点属性集")
    private CePointPropsJsonObject cePointProps;

}
