package com.gaea.iesms.bm.archive.model.request.ceResourceDetail;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.SuperBuilder;

import javax.validation.constraints.NotNull;

/**
 * @author JIE
 * @version 1.0
 * @description: 查询能资源树
 * @date 2023/4/11 17:52
 */
@Data
@SuperBuilder
@ApiModel(value = "查询能资源树")
public class GetCeResourceDetailRequest {

    /**
     * 树id
     */
    @NotNull(message = "树id不能为空")
    @ApiModelProperty("树id")
    private String treeId;

    /**
     * 上级id
     */
    @ApiModelProperty("上级id")
    private Long superiorId;

    @ApiModelProperty(value = "上级用能资源类别 1 - 用能客户；2 - 用能区域；3 - 用能容器；4 - 用能设备")
    private Integer supperCeResClass;

    /**
     * 上级用能资源分类编号
     */
    @ApiModelProperty("上级用能资源分类编号")
    private String supperCeResSortNo;

    @ApiModelProperty(value = "下级用能资源类别 （1 - 用能客户；2 - 用能区域；3 - 用能容器；4 - 用能设备）")
    private Integer lowerCeResClass;

    /**
     * 下级能源类型
     *
     * @see com.gaea.iesms.core.model.enums.archive.CeResTypeEnum
     */
    @ApiModelProperty(value = "下级能源类型 源：source  网：net  荷：eload  储：stroe   充：charge")
    private String lowerCeResType;
}
