package com.gaea.iesms.bm.archive.model.request.ceResourceDetail;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 修改用能资源树明细请求类
 *
 * @author JIE
 */
@Data
@ApiModel(description = "修改用能资源树明细请求类")
public class UpdateCeResourceDetailRequest {

    /**
     * 用能资源树明细标识 SnowflakeId
     */
    @ApiModelProperty(value = "用能资源树明细标识")
    private Long id;

    /**
     * 上级用能资源类别
     *
     * @see com.gaea.iesms.core.model.enums.archive.CeResClassEnum
     */
    @ApiModelProperty(value = "上级用能资源类别 （1 - 用能客户；2 - 用能区域；3 - 用能容器；4 - 用能设备）")
    private Integer supperCeResClass;

    /**
     * 上级用能资源分类编号
     */
    @ApiModelProperty(value = "上级用能资源分类编号")
    private String supperCeResSortNo;

    /**
     * 下级用能资源类别
     *
     * @see com.gaea.iesms.core.model.enums.archive.CeResClassEnum
     */
    @ApiModelProperty(value = "下级用能资源类别 （1 - 用能客户；2 - 用能区域；3 - 用能容器；4 - 用能设备）")
    private Integer lowerCeResClass;

    /**
     * 下级用能资源分类编号
     */
    @ApiModelProperty(value = "下级用能资源分类编号")
    private String lowerCeResSortNo;

    /**
     * 下级能源类型
     *
     * @see com.gaea.iesms.core.model.enums.archive.CeResTypeEnum
     */
    @ApiModelProperty(value = "下级能源类型 源：source  网：net  荷：eload  储：stroe   充：charge")
    private String lowerCeResType;
}
