package com.gaea.iesms.bm.archive.model.response.dto.ceResourceSort;

import com.gaea.iesms.core.model.jsonobject.archive.DefaultPropsJsonObject;
import com.gaea.iesms.core.model.jsonobject.archive.TemplatePropsJsonObject;
import lombok.Data;

import java.util.List;

/**
 * 查询返回用能资源分类（自动配置）返回Dto
 *
 * @author JIE
 */
@Data
public class CeResourceSortDto {

    /**
     * 用能资源类别 1 - 用能客户； 2 - 用能区域； 3 - 用能容器；4 - 用能设备；
     */
    private Integer ceResClass;

    /**
     * 用能资源类型
     */
    private String ceResType;

    /**
     * 用能资源分类编号
     */
    private String ceResSortNo;

    /**
     * 用能资源分类Id
     */
    private String ceResSortNoId;

    /**
     * 用能资源分类名称
     */
    private String ceResSortName;

    /**
     * 用能资源分类别名
     */
    private String ceResSortAlias;

    /**
     * 用能资源分类说明
     */
    private String ceResSortDesc;

    /**
     * 用能资源分类图标
     */
    private String ceResSortIcon;

    /**
     * 用能资源属性集模板
     */
    private List<TemplatePropsJsonObject> templateProps;

    /**
     * 用能资源属性默认值
     */
    private DefaultPropsJsonObject defaultProps;

    /**
     * 排序序号
     */
    private Integer sortSn;

    /**
     * 是否有效
     */
    private Boolean isValid;

    /**
     * 创建人 系统用户表用户编号字段（user_no）
     */
    private String creator;

    /**
     * 创建时间 为0表示为空
     */
    private Long gmtCreate;

    /**
     * 更新人 系统用户表用户编号字段（user_no）
     */
    private String modifier;

    /**
     * 更新时间 为0表示为空
     */
    private Long gmtModified;

    /**
     * 失效人 系统用户表用户编号字段（user_no）
     */
    private String invalider;

    /**
     * 失效时间 为0表示为空
     */
    private Long gmtInvalid;

    /**
     * 版本号 用于乐观锁
     */
    private Integer version;
}
