package com.gaea.iesms.bm.archive.model.response.vo.ceCust;

import com.gaea.iesms.core.model.enums.archive.CeResTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 资源类型
 *
 * @author JIE
 * @version 1.0
 * @date 2023/7/21 16:08
 */
@Data
@ApiModel("资源类型信息")
public class CeResTypeVo {

    @ApiModelProperty("资源类型")
    private String ceResType;

    @ApiModelProperty("资源类型Name")
    private String ceResTypeName;

    @ApiModelProperty("是否有树节点")
    private Boolean hasChildren;

    public void setCeResType(String ceResType) {
        this.ceResType = ceResType;
        switch (CeResTypeEnum.fromCode(ceResType)) {
            case SOURCE:
                this.ceResTypeName = "源";
                break;
            case NET:
                this.ceResTypeName = "网";
                break;
            case ELOAD:
                this.ceResTypeName = "荷";
                break;
            case STORE:
                this.ceResTypeName = "储";
                break;
            case CHARGE:
                this.ceResTypeName = "充";
                break;
            default:
        }
    }
}
