package com.gaea.iesms.bm.archive.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.gaea.iesms.bm.archive.model.response.dto.ceCust.CeCustDto;
import com.gaea.iesms.core.feign.request.archive.AddCeCustRequest;
import com.gaea.iesms.core.feign.request.archive.QueryUserRequest;
import com.gaea.iesms.core.feign.request.archive.UpdateCeCustRequest;
import com.gaea.iesms.core.feign.request.archive.UserPageRequest;
import com.gaea.iesms.core.feign.response.archive.CeCustVo;
import com.gaea.iesms.core.model.entity.archive.CeCust;

import java.util.List;

/**
 * 针对表【ce_cust(用能客户 用能资源子表)】的数据库操作Service
 *
 * @author JIE
 * @createDate 2023-02-20 09:01:25
 */
public interface CeCustService extends IService<CeCust> {

    /**
     * 增加用户档案
     *
     * @param: addUserRequest
     * @return: boolean
     * @author JIE
     * @date: 2024/1/31 9:27
     */
    boolean addCeCust(AddCeCustRequest addUserRequest);

    /**
     * 批量增加用户档案
     *
     * @param: addUserRequest
     * @return: boolean
     * @author JIE
     * @date: 2024/1/31 9:27
     */
    boolean addCeCustBatch(List<AddCeCustRequest> addUserRequest);

    /**
     * 批量增加用户档案(虚拟电厂特供)
     *
     * @param: addUserRequest
     * @return: boolean
     * @author JIE
     * @date: 2024/1/31 9:27
     */
    List<String> addVppCeCustBatch(List<AddCeCustRequest> addUserRequest);

    /**
     * 根据用户档案id修改用户档案
     *
     * @param: request 请求参数
     * @return: boolean
     * @author JIE
     * @date: 2024/1/31 13:40
     */
    boolean updateUserProfile(UpdateCeCustRequest request);

    /**
     * 查询单个用户档案
     *
     * @param: queryUserRequest
     * @return: com.gaea.iesms.bm.archive.model.response.dto.ceCust.CeCustDto
     * @author JIE
     * @date: 2024/1/31 14:10
     */
    CeCustVo queryUserFileAccordConduit(QueryUserRequest queryUserRequest);

    /**
     * 查询用户档案列表
     *
     * @param: userPageRequest
     * @return: com.gaea.iesms.bm.archive.model.response.dto.ceCust.CeCustPageDto
     * @author JIE
     * @date: 2024/1/31 14:18
     */
    IPage<CeCustDto> listPagedUserProfiles(UserPageRequest userPageRequest);
}
