package com.gaea.iesms.bm.archive.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.gaea.iesms.bm.archive.model.request.ceResourceSort.AddCeResourceSortRequest;
import com.gaea.iesms.bm.archive.model.request.ceResourceSort.QueryCeResourceSortRequest;
import com.gaea.iesms.bm.archive.model.request.ceResourceSort.UpdateCeResourceSortRequest;
import com.gaea.iesms.bm.archive.model.response.dto.ceResourceSort.CeResourceSortDto;
import com.gaea.iesms.core.model.entity.archive.CeResourceSort;

import java.util.List;

/**
 * @author Administrator
 * @description 针对表【ce_resource_sort(用能资源分类（自动配置）)】的数据库操作Service
 * @createDate 2023-04-11 10:26:43
 */
public interface CeResourceSortService extends IService<CeResourceSort> {

    /**
     * 添加 用能资源分类
     *
     * @param ceResourceSortAddRequest 用能资源分类（自动配置）增加请求类
     * @return: 1、成功 0、失败
     * @author: JIE
     * @date: 2023/4/11 11:15
     */
    Integer addCeResourceSort(AddCeResourceSortRequest ceResourceSortAddRequest);

    /**
     * 根据id删除
     *
     * @param: id
     * @return: 1、成功 0 、失败
     * @author: JIE
     * @date: 2023/4/11 11:22
     */
    Integer removeCeResourceSortById(String id);

    /**
     * 修改用能资源分类
     *
     * @param: ceResourceSortUpdateRequest
     * @return: 1、成功 2、失败
     * @author: JIE
     * @date: 2023/4/11 11:24
     */
    Integer updateCeResourceSort(UpdateCeResourceSortRequest ceResourceSortUpdateRequest);

    /**
     * 根据ID查询用能资源分类
     *
     * @param id 用能资源分类id
     * @return: CeResourceSortDto
     * @author: JIE
     * @date: 2023/4/11 11:41
     */
    CeResourceSortDto queryCeResourceSortById(String id);

    /**
     * 查询用能资源分类
     *
     * @param: queryCeResourceSortRequest
     * @return: CeResourceSortDto
     * @author: JIE
     * @date: 2023/4/11 11:41
     */
    List<CeResourceSortDto> queryCeResourceSortByCeResClass(QueryCeResourceSortRequest queryCeResourceSortRequest);
}
