package com.gaea.iesms.bm.archive.service.impl;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gaea.base.error.BizException;
import com.gaea.iesms.bm.archive.mapper.CeResourceMicConfigMapper;
import com.gaea.iesms.bm.archive.model.request.BatchAddConfigRequest;
import com.gaea.iesms.core.feign.request.archive.QueryMicConfigRequest;
import com.gaea.iesms.core.feign.dto.QueryCeResourceMicConfigDto;
import com.gaea.iesms.bm.archive.service.CeResourceMicConfigService;
import com.gaea.iesms.bm.archive.service.CeResourceService;
import com.gaea.iesms.core.model.entity.archive.CeResource;
import com.gaea.iesms.core.model.entity.archive.CeResourceMicConfig;
import com.gaea.spring.cloud.starter.util.AuthUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * 用能资源量测项编码配置
 *
 * @author JIE
 * @version 1.0
 * @date 2023/12/1 16:16
 */
@Service
public class CeResourceMicConfigServiceImpl extends ServiceImpl<CeResourceMicConfigMapper, CeResourceMicConfig>
        implements CeResourceMicConfigService {

    @Resource
    private CeResourceService ceResourceService;

    @Resource
    private CeResourceMicConfigMapper ceResourceMicConfigMapper;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public Boolean batchAddConfig(BatchAddConfigRequest requests) {
        String id = requests.getId();
        CeResource ceResource = ceResourceService.getById(id);
        if (ceResource == null) {
            throw BizException.of("该用能资源已被删除，请重新选择");
        }

        String orgNo = AuthUtils.getOrgNo();

        // 先删后加
        ceResourceMicConfigMapper.deleteByCeResId(ceResource.getId());

        List<CeResourceMicConfig> ceResourceMicConfigs = new ArrayList<>();
        List<String> measItemCode = requests.getMeasItemCode();
        measItemCode.forEach(item -> {
            CeResourceMicConfig ceResourceMicConfig = new CeResourceMicConfig();
            ceResourceMicConfig.setCeResClass(ceResource.getCeResClass());
            ceResourceMicConfig.setOrgNo(orgNo);
            ceResourceMicConfig.setMeasItemCode(item);
            ceResourceMicConfig.setCeResId(Long.valueOf(id));
            ceResourceMicConfig.setDisplayType(2);
            ceResourceMicConfigs.add(ceResourceMicConfig);
        });
        return saveBatch(ceResourceMicConfigs);
    }

    @Override
    public List<QueryCeResourceMicConfigDto> queryCeResourceMicConfig(QueryMicConfigRequest request) {
        return ceResourceMicConfigMapper.queryCeResourceMicConfig(request);
    }
}
