package com.gaea.iesms.bm.archive.config;

import com.zaxxer.hikari.HikariDataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

import javax.sql.DataSource;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2022/5/10
 */
@Configuration
@Order(Ordered.HIGHEST_PRECEDENCE)
@SuppressWarnings("all")
public class ArchiveDataSourceConfig {

    @Bean(name = "archiveDataSource")
    @Qualifier("archiveDataSource")
    @Primary
    @ConfigurationProperties(prefix = "spring.datasource.hikari.active")
    DataSource archiveDataSource() {
        return DataSourceBuilder.create().type(HikariDataSource.class).build();
    }

    @Bean(name = "archiveTransactionManager")
    @Qualifier("archiveTransactionManager")
    @Primary
    public DataSourceTransactionManager archiveTransactionManager(@Qualifier("archiveDataSource") DataSource archiveDataSource) {
        return new DataSourceTransactionManager(archiveDataSource);
    }
}
