package com.gaea.iesms.bm.archive.controller;


import com.gaea.base.core.R;
import com.gaea.base.vo.PageDataVo;
import com.gaea.iesms.bm.archive.model.request.ceContainer.CeContainerRequest;
import com.gaea.iesms.bm.archive.model.request.ceContainer.UpdateCeContainerRequest;
import com.gaea.iesms.bm.archive.service.CeContainerService;
import com.gaea.iesms.core.feign.request.archive.PagedContainersRequest;
import com.gaea.iesms.core.feign.response.archive.CeContainerVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.Valid;

/**
 * @author JIE
 * @version 1.0
 * @description: 用能容器档案管理
 * @date 2023/3/20 14:18
 */
@Api(tags = "用能容器档案管理")
@RestController
@RequestMapping("container")
public class CeContainerController {

    @Resource
    private CeContainerService ceContainerService;

    @ApiOperation(value = "增加用能容器档案", notes = "返回用能容器主键id")
    @PostMapping("/addContainer")
    public R<String> addContainer(@RequestBody CeContainerRequest ceContainerRequest) {
        // 调用增加方法
        return R.ok(ceContainerService.addCeContainer(ceContainerRequest));
    }

    @ApiOperation(value = "修改用能容器")
    @PutMapping("/updateContainerById")
    public R<Boolean> updateContainerByProfileId(@RequestBody @Valid UpdateCeContainerRequest ceContainerRequest) {
        // 调用修改方法
        Boolean aBoolean = ceContainerService.updateContainerByProfileId(ceContainerRequest);
        return R.ok(aBoolean);
    }

    @ApiParam(name = "id", value = "用能容器档案id", required = true)
    @ApiOperation(value = "查询用能容器详细信息")
    @GetMapping("/getContainerById")
    public R<CeContainerVo> getContainerById(@RequestParam("id") String id) {
        CeContainerVo ceContainerVo = ceContainerService.getContainerById(id);
        return R.ok(ceContainerVo);
    }

    @ApiOperation(value = "分页查询用能容器档案")
    @GetMapping("/listPagedContainers")
    public R<PageDataVo<CeContainerVo>> listPagedContainers(PagedContainersRequest request) {
        return R.ok(ceContainerService.listPagedContainers(request));
    }
}
