package com.gaea.iesms.bm.archive.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gaea.base.core.R;
import com.gaea.base.enums.HandleCodeEnum;
import com.gaea.base.vo.PageDataVo;
import com.gaea.iesms.bm.archive.model.response.dto.ceCust.CeCustDto;
import com.gaea.iesms.bm.archive.service.CeCustService;
import com.gaea.iesms.core.feign.request.archive.AddCeCustRequest;
import com.gaea.iesms.core.feign.request.archive.QueryUserRequest;
import com.gaea.iesms.core.feign.request.archive.UpdateCeCustRequest;
import com.gaea.iesms.core.feign.request.archive.UserPageRequest;
import com.gaea.iesms.core.feign.response.archive.CeCustVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * 用户档案管理
 *
 * @author JIE
 * @version 1.0
 * @date 2024/1/31 10:28
 */
@Api(tags = "用户档案管理")
@RestController
@RequestMapping("/ceCust")
@Slf4j
public class CeCustController {

    @Resource
    private CeCustService ceCustService;

    @ApiOperation(value = "增加用户档案", notes = "1、成功 0、失败")
    @PostMapping("/addCeCust")
    public R<HandleCodeEnum> addCeCust(@RequestBody AddCeCustRequest addUserRequest) {
        // 调用增加方法
        boolean b = ceCustService.addCeCust(addUserRequest);
        if (b) {
            return R.enums(HandleCodeEnum.INSERT_SUCCESS);
        }
        return R.enums(HandleCodeEnum.INSERT_ERROR);
    }

    @ApiOperation("批量新增用户档案")
    @PostMapping("/addCeCustBatch")
    public R<HandleCodeEnum> addCeCustBatch(@RequestBody List<AddCeCustRequest> addUserRequest) {
        // 调用增加方法
        boolean b = ceCustService.addCeCustBatch(addUserRequest);
        if (b) {
            return R.enums(HandleCodeEnum.INSERT_SUCCESS);
        }
        return R.enums(HandleCodeEnum.INSERT_ERROR);
    }

    @ApiOperation("批量新增用户档案(虚拟电厂特供)")
    @PostMapping("/addVppCeCustBatch")
    public R<List<String>> addVppCeCustBatch(@RequestBody List<AddCeCustRequest> addUserRequest) {
        // 调用增加方法
        List<String> strings = ceCustService.addVppCeCustBatch(addUserRequest);
        if (CollectionUtil.isNotEmpty(strings)) {
            return R.ok(strings);
        } else {
            return R.failure().msg("新增失败");
        }
    }

    @ApiOperation(value = "修改用户档案")
    @PutMapping("/updateUserProfile")
    public R<HandleCodeEnum> updateUserProfile(@RequestBody UpdateCeCustRequest ceCustRequest) {
        boolean b = ceCustService.updateUserProfile(ceCustRequest);
        if (b) {
            return R.enums(HandleCodeEnum.MODIFY_SUCCESS);
        }
        return R.enums(HandleCodeEnum.MODIFY_ERROR);
    }

    @ApiOperation(value = "查询单个用户档案")
    @GetMapping("/getUserProfileByCurrentLoginAccount")
    public R<CeCustVo> getUserProfileByCurrentLoginAccount(QueryUserRequest queryUserRequest) {
        CeCustVo ceCustVo = ceCustService.queryUserFileAccordConduit(queryUserRequest);
        return R.ok(ceCustVo);
    }

    @ApiOperation(value = "分页查询用户档案 ", notes = "多个用户档案")
    @PostMapping("/listPagedUserProfiles")
    public R<PageDataVo<CeCustVo>> listPagedUserProfiles(@RequestBody UserPageRequest userPageRequest) {
        // 通过服务层调用，进行分页查询用户档案
        IPage<CeCustDto> ceCustDtoIPage = ceCustService.listPagedUserProfiles(userPageRequest);
        IPage<CeCustVo> convert = ceCustDtoIPage.convert(ceCustDto -> {
            CeCustVo pageCeCustVo = new CeCustVo();
            BeanUtils.copyProperties(ceCustDto, pageCeCustVo); // 使用BeanUtils进行属性拷贝
            return pageCeCustVo;
        });
        // 构建并返回响应结果
        return R.ok(convert);
    }
}
