package com.gaea.iesms.bm.archive.controller;

import com.gaea.base.core.R;
import com.gaea.base.vo.PageDataVo;
import com.gaea.iesms.bm.archive.model.request.ceDeivce.CeDeviceRequest;
import com.gaea.iesms.bm.archive.model.request.ceDeivce.UpdateCeDeviceRequest;
import com.gaea.iesms.bm.archive.model.response.vo.ceResource.IntervalVo;
import com.gaea.iesms.bm.archive.service.CeDeviceService;
import com.gaea.iesms.core.feign.request.archive.PagedDevicesRequest;
import com.gaea.iesms.core.feign.response.archive.CeDeviceVo;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author JIE
 * @version 1.0
 * @description: 用能设备档案管理
 * @date 2023/3/21 16:48
 */
@Api(tags = "用能设备档案管理")
@RestController
@RequestMapping("/ceDevice")
public class CeDeviceController {

    @Resource
    private CeDeviceService ceDeviceService;

    @ApiOperation(value = "增加设备档案", notes = "1、成功 0、失败")
    @PostMapping("/addCeDevice")
    public R<String> addCeDevice(@RequestBody CeDeviceRequest request) {
        return R.ok(ceDeviceService.addCeDevice(request));
    }

    @ApiOperation(value = "修改设备档案")
    @PutMapping("/updateDeviceById")
    public R<Boolean> updateDeviceById(@RequestBody UpdateCeDeviceRequest request) {
        Boolean aBoolean = ceDeviceService.updateDeviceById(request);
        return R.ok(aBoolean);
    }

    @ApiParam(name = "id", value = "用能设备档案id", required = true)
    @ApiOperation(value = "查询用能设备档案详细信息")
    @GetMapping("/getDeviceById")
    public R<CeDeviceVo> getDeviceById(@RequestParam("id") String id) {
        CeDeviceVo ceDeviceVo = ceDeviceService.getDeviceById(id);
        return R.ok(ceDeviceVo);
    }

    @ApiOperation(value = "分页查询用能设备档案")
    @GetMapping("/listPagedDevices")
    public R<PageDataVo<CeDeviceVo>> listPagedDevices(PagedDevicesRequest request) {
        return R.ok(ceDeviceService.listPagedDevices(request));
    }

    @ApiImplicitParams({
            @ApiImplicitParam(name = "keyWord", value = "搜索关键词", required = true, dataType = "String"),
    })
    @ApiOperation(value = "搜索间隔")
    @GetMapping("/listPageDevice")
    public R<List<IntervalVo>> searchIntervals(String keyWord) {
        List<IntervalVo> intervalVos = ceDeviceService.searchIntervals(keyWord);
        return R.ok(intervalVos);
    }
}
