package com.gaea.iesms.bm.archive.controller;

import com.gaea.base.core.R;
import com.gaea.iesms.bm.archive.model.request.MeasurementItemParamsRequest;
import com.gaea.iesms.bm.archive.model.response.vo.MeasurementItemParamsVo;
import com.gaea.iesms.bm.archive.service.CeModelMicConfigService;
import com.gaea.iesms.core.feign.request.AllMeasurementItemsRequest;
import com.gaea.iesms.core.model.entity.archive.CeModelMicConfig;
import com.gaea.iesms.core.model.entity.archive.dto.MeasurementItemDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 量测表计设备型号量测项编码配置
 *
 * @author JIE
 * @version 1.0
 * @date 2024/3/29 15:05
 */
@Api(tags = "量测表计设备型号量测项编码配置")
@RestController
@RequestMapping("/ceModelMicConfig")
public class CeModelMicConfigController {

    @Resource
    private CeModelMicConfigService ceModelMicConfigService;

    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "modelCode", value = "型号编码", required = true, dataType = "String", paramType = "query")
    })
    @ApiOperation(value = "获取量测项三项")
    @GetMapping("getLeftThreeMeasurementItems")
    public R<List<MeasurementItemDto>> getLeftThreeMeasurementItems(@RequestParam("modelCode") String modelCode) {
        return R.ok(ceModelMicConfigService.getLeftThreeMeasurementItems(modelCode));
    }

    @ApiOperation(value = "量测表计设备型号量测项编码")
    @GetMapping("getAllMeasurementItems")
    public R<List<CeModelMicConfig>> getAllMeasurementItems(AllMeasurementItemsRequest request) {
        return R.ok(ceModelMicConfigService.getAllMeasurementItems(request));
    }

    @ApiOperation(value = "获取其他量测项")
    @GetMapping("/getMeasurementItemParams")
    public R<List<MeasurementItemParamsVo>> getMeasurementItemParams(MeasurementItemParamsRequest request) {
        List<MeasurementItemParamsVo> measurementItemParams = ceModelMicConfigService.getMeasurementItemParams(request);
        return R.ok(measurementItemParams);
    }
}
