package com.gaea.iesms.bm.archive.controller;


import com.gaea.base.core.R;
import com.gaea.iesms.bm.archive.model.request.BatchAddConfigRequest;
import com.gaea.iesms.core.feign.request.archive.QueryMicConfigRequest;
import com.gaea.iesms.core.feign.dto.QueryCeResourceMicConfigDto;
import com.gaea.iesms.bm.archive.service.CeResourceMicConfigService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.util.List;

/**
 * 用能资源量测项编码配置管理
 *
 * @author JIE
 * @version 1.0
 * @date 2023/12/1 16:19
 */
@Api(tags = "用能资源量测项编码配置管理")
@RequestMapping("/resourceMicConfig")
@RestController
public class CeResourceMicConfigController {

    @Resource
    private CeResourceMicConfigService ceResourceMicConfigService;

    @ApiOperation(value = "增加用能资源量测项编码配置")
    @PostMapping("/batchAddConfig")
    public R<Boolean> batchAddConfig(@RequestBody @Valid BatchAddConfigRequest request) {
        Boolean b = ceResourceMicConfigService.batchAddConfig(request);
        return R.ok(b);
    }

    @ApiOperation(value = "查询用能资源量测项编码配置")
    @GetMapping("/queryCeResourceMicConfig")
    public R<List<QueryCeResourceMicConfigDto>> queryCeResourceMicConfig(QueryMicConfigRequest request) {
        return R.ok(ceResourceMicConfigService.queryCeResourceMicConfig(request));
    }
}
