package com.gaea.iesms.bm.archive.controller;

import com.gaea.base.core.R;
import com.gaea.base.enums.HandleCodeEnum;
import com.gaea.iesms.bm.archive.model.request.ceResourceSort.AddCeResourceSortRequest;
import com.gaea.iesms.bm.archive.model.request.ceResourceSort.QueryCeResourceSortRequest;
import com.gaea.iesms.bm.archive.model.request.ceResourceSort.UpdateCeResourceSortRequest;
import com.gaea.iesms.bm.archive.model.response.dto.ceResourceSort.CeResourceSortDto;
import com.gaea.iesms.bm.archive.model.response.vo.ceResourceSort.CeResourceSortVo;
import com.gaea.iesms.bm.archive.service.CeResourceSortService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * @author JIE
 * @version 1.0
 * @description: 用能资源分类
 * @date 2023/4/11 10:36
 */
@RestController
@RequestMapping("/ceResourceSort")
@Api(tags = "用能资源分类管理")
public class CeResourceSortController {

    @Resource
    private CeResourceSortService ceResourceSortService;

    /**
     * 添加 用能资源分类
     *
     * @param ceResourceSortAddRequest 用能资源分类（自动配置）增加请求类
     * @return: 1、成功 0、失败
     * @author: JIE
     * @date: 2023/4/11 11:15
     */
    @ApiOperation(value = "添加用能资源分类")
    @PostMapping("/addGmDevCollector")
    public R addCeResourceSort(@RequestBody AddCeResourceSortRequest ceResourceSortAddRequest) {
        Integer integer = ceResourceSortService.addCeResourceSort(ceResourceSortAddRequest);
        if (integer > 0) {
            return R.enums(HandleCodeEnum.INSERT_SUCCESS);
        }
        return R.enums(HandleCodeEnum.INSERT_ERROR);
    }

    /**
     * 删除 用能资源分类
     *
     * @param id 用能资源分类id
     * @return: 1、成功 0、失败
     * @author: JIE
     * @date: 2023/4/11 11:15
     */
    @ApiImplicitParam(name = "id", value = "用能资源分类id", required = true, dataType = "String")
    @ApiOperation(value = "删除用能资源分类")
    @DeleteMapping("/removeCeResourceSort")
    public R removeCeResourceSort(String id) {
        Integer integer = ceResourceSortService.removeCeResourceSortById(id);
        if (integer > 0) {
            return R.enums(HandleCodeEnum.DELETE_SUCCESS);
        }
        return R.enums(HandleCodeEnum.DELETE_ERROR);
    }


    /**
     * 修改 用能资源分类
     *
     * @param ceResourceSortUpdateRequest 用能资源分类（自动配置）修改请求类
     * @return: 1、成功 0、失败
     * @author: JIE
     * @date: 2023/4/11 11:15
     */
    @ApiOperation("修改用能资源分类")
    @PutMapping("/updateCeResourceSort")
    public R updateCeResourceSort(@RequestBody UpdateCeResourceSortRequest ceResourceSortUpdateRequest) {
        Integer integer = ceResourceSortService.updateCeResourceSort(ceResourceSortUpdateRequest);
        if (integer > 0) {
            return R.enums(HandleCodeEnum.HANDLE_SUCCESS);
        }
        return R.enums(HandleCodeEnum.HANDLE_ERROR);
    }

    /**
     * 根据id查询用能资源分类信息
     *
     * @param: id
     * @return:
     * @author: JIE
     * @date: 2023/4/12 9:22
     */
    @ApiImplicitParam(name = "id", value = "用能资源分类id", required = true, dataType = "String")
    @ApiOperation("根据id查询用能资源分类信息")
    @GetMapping("/queryCeResourceSort/{id}")
    public R<CeResourceSortVo> queryCeResourceSortById(@PathVariable String id) {
        CeResourceSortDto ceResourceSortDto = ceResourceSortService.queryCeResourceSortById(id);
        CeResourceSortVo ceResourceSortVo = new CeResourceSortVo();
        BeanUtils.copyProperties(ceResourceSortDto, ceResourceSortVo);
        return R.ok(ceResourceSortVo);
    }

    /**
     * 批量查询用能资源分类信息
     *
     * @param queryCeResourceSortRequest
     * @return: 用能资源分类信息集合
     * @author: JIE
     * @date: 2023/4/12 9:22
     */
    @ApiOperation("根据条件批量查询用能资源分类信息")
    @GetMapping("/queryCeResourceSort")
    public R<List<CeResourceSortVo>> queryCeResourceSortById(QueryCeResourceSortRequest queryCeResourceSortRequest) {
        List<CeResourceSortDto> dtoList = ceResourceSortService.queryCeResourceSortByCeResClass(queryCeResourceSortRequest);
        List<CeResourceSortVo> ceResourceSortVoList = new ArrayList<>();
        for (CeResourceSortDto ceResourceSortDto : dtoList) {
            CeResourceSortVo ceResourceSortVo = new CeResourceSortVo();
            BeanUtils.copyProperties(ceResourceSortDto, ceResourceSortVo);
            ceResourceSortVoList.add(ceResourceSortVo);
        }
        return R.ok(ceResourceSortVoList);
    }
}
