package com.gaea.iesms.bm.archive.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gaea.iesms.bm.archive.model.request.cePoint.CePointPageRequest;
import com.gaea.iesms.core.model.entity.archive.CePoint;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

/**
 * 针对表【ce_point(用能点 )】的数据库操作Mapper
 *
 * @author JIE
 */
@Mapper
public interface CePointMapper extends BaseMapper<CePoint> {

    /**
     * 分页查询用能点列表
     *
     * @param page               分页参数
     * @param cePointPageRequest 用能点查询条件
     * @return 用能点分页数据
     */
    IPage<CePoint> selectCePointPage(Page<CePoint> page, @Param("cePoint") CePointPageRequest cePointPageRequest);

}
