package com.gaea.iesms.bm.archive.model.request.ceResourceSort;

import com.gaea.iesms.core.model.jsonobject.archive.DefaultPropsJsonObject;
import com.gaea.iesms.core.model.jsonobject.archive.TemplatePropsJsonObject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 用能资源分类（自动配置）增加请求类
 *
 * @author Administrator
 */
@Data
@ApiModel(description = "增加用能资源分类（自动配置）请求类")
public class AddCeResourceSortRequest {

    /**
     * 用能资源类别
     *
     * @see com.gaea.iesms.core.model.enums.archive.CeResClassEnum
     */
    @ApiModelProperty(value = "用能资源类别（1 - 用能客户；2 - 用能区域；3 - 用能容器；4 - 用能设备）")
    private Integer ceResClass;

    /**
     * 用能资源类型
     *
     * @see com.gaea.iesms.core.model.enums.archive.CeResTypeEnum
     */
    @ApiModelProperty(value = "用能资源类型 源：source  网：net  荷：eload  储：stroe   充：charge ")
    private String ceResType;

    /**
     * 用能资源分类编号
     */
    @ApiModelProperty(value = "用能资源分类编号")
    private String ceResSortNo;

    /**
     * 用能资源分类名称
     */
    @ApiModelProperty(value = "用能资源分类名称")
    private String ceResSortName;

    /**
     * 用能资源分类别名
     */
    @ApiModelProperty(value = "用能资源分类别名")
    private String ceResSortAlias;

    /**
     * 用能资源分类说明
     */
    @ApiModelProperty(value = "用能资源分类说明")
    private String ceResSortDesc;

    /**
     * 用能资源分类图标
     */
    @ApiModelProperty(value = "用能资源分类图标")
    private String ceResSortIcon;

    /**
     * 用能资源属性集模板
     */
    @ApiModelProperty(value = "用能资源属性集模板")
    private TemplatePropsJsonObject templateProps;

    /**
     * 用能资源属性默认值
     */
    @ApiModelProperty(value = "用能资源属性默认值")
    private DefaultPropsJsonObject defaultProps;
}
