package com.gaea.iesms.bm.archive.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.gaea.iesms.bm.archive.model.request.ceContainer.CeContainerRequest;
import com.gaea.iesms.bm.archive.model.request.ceContainer.UpdateCeContainerRequest;
import com.gaea.iesms.core.feign.request.archive.PagedContainersRequest;
import com.gaea.iesms.core.feign.response.archive.CeContainerVo;
import com.gaea.iesms.core.model.entity.archive.CeContainer;

/**
 * 针对表【ce_container(用能容器 )】的数据库操作Service
 *
 * @author JIE
 * @createDate 2023-02-20 09:41:47
 */
public interface CeContainerService extends IService<CeContainer> {

    /**
     * 增加容器档案
     *
     * @param ceContainerRequest 请求参数
     * @return 主键id
     * @author JIE
     * @date: 2023/11/9 9:43
     */
    String addCeContainer(CeContainerRequest ceContainerRequest);

    /**
     * 修改用能容器
     *
     * @param request 请求参数
     * @return true 成功 false 失败
     * @author JIE
     * @date: 2023/11/10 9:44
     */
    Boolean updateContainerByProfileId(UpdateCeContainerRequest request);

    /**
     * 查询单个用能容器档案详细信息
     *
     * @param id 用能容器档案id
     * @return CeContainerDto
     * @author JIE
     * @date: 2023/11/27 10:33
     */
    CeContainerVo getContainerById(String id);

    /**
     * 分页查询用能容器档案
     *
     * @param: request
     * @return: com.baomidou.mybatisplus.core.metadata.IPage<com.gaea.iesms.core.feign.response.archive.CeContainerVo>
     * @author JIE
     * @date: 2024/4/1 14:45
     */
    IPage<CeContainerVo> listPagedContainers(PagedContainersRequest request);
}
