package com.gaea.iesms.bm.archive.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.gaea.iesms.bm.archive.model.request.MeasurementItemParamsRequest;
import com.gaea.iesms.bm.archive.model.response.vo.MeasurementItemParamsVo;
import com.gaea.iesms.core.feign.request.AllMeasurementItemsRequest;
import com.gaea.iesms.core.model.entity.archive.CeModelMicConfig;
import com.gaea.iesms.core.model.entity.archive.dto.MeasurementItemDto;

import java.util.List;

/**
 * 量测表计设备型号量测项编码配置
 *
 * @author JIE
 * @version 1.0
 * @date 2024/3/29 15:05
 */
public interface CeModelMicConfigService extends IService<CeModelMicConfig> {

    /**
     * 获取量测项三项
     *
     * @param: modelCode 设备型号
     * @return: java.util.List<com.gaea.iesms.core.model.entity.archive.dto.MeasurementItemDto>
     * @author JIE
     * @date: 2024/3/29 15:04
     */
    List<MeasurementItemDto> getLeftThreeMeasurementItems(String modelCode);

    /**
     * 量测表计设备型号量测项编码
     *
     * @param: request
     * @return: java.util.List<com.gaea.iesms.core.model.entity.archive.CeModelMicConfig>
     * @author JIE
     * @date: 2024/3/29 15:04
     */
    List<CeModelMicConfig> getAllMeasurementItems(AllMeasurementItemsRequest request);

    /**
     * 获取其他量测项
     *
     * @param: id 用能资源id
     * @return: MeasurementItemParamsVo
     * @author JIE
     * @date: 2023/12/1 15:52
     */
    List<MeasurementItemParamsVo> getMeasurementItemParams(MeasurementItemParamsRequest request);
}
