package com.gaea.iesms.bm.archive.service;

import com.gaea.iesms.core.feign.dto.DevMeterIdAndCeResIdDto;
import com.gaea.iesms.core.model.entity.archive.CePointMeter;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
 * 用能点量测表计关系
 * @author JIE
 * @date 2024/1/31 10:17
 * @version 1.0
 */
public interface CePointMeterService extends IService<CePointMeter>{

    /**
     * 根据用能资源Id 获取量测表计ID集合
     *
     * @param ceResIds 用能资源ID集合
     * @return 量测表计ID集合
     * @author JIE
     * @date: 2023/11/28 15:31
     */
    List<DevMeterIdAndCeResIdDto> getDevMeterIdListByCeResIds(List<Long> ceResIds);

    /**
     * 物理删除用能id 和表计关系
     *
     * @param: cePointIds 用能点id集合
     * @return: int
     * @author JIE
     * @date: 2023/12/6 9:16
     */
    int removeByCePointIds(List<Long> cePointIds);

}
