package com.gaea.iesms.bm.archive.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gaea.iesms.bm.archive.mapper.CePointMapper;
import com.gaea.iesms.bm.archive.model.request.cePoint.CePointPageRequest;
import com.gaea.iesms.bm.archive.model.response.dto.CePoint.CePointDto;
import com.gaea.iesms.bm.archive.model.response.dto.CePoint.CePointPageDto;
import com.gaea.iesms.bm.archive.service.CePointService;
import com.gaea.iesms.core.model.entity.archive.CePoint;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
* @author JIE
* @description 针对表【ce_point(用能点 )】的数据库操作Service实现
* @createDate 2023-03-07 11:00:25
*/
@Service
public class CePointServiceImpl extends ServiceImpl<CePointMapper, CePoint>
    implements CePointService{

    @Resource
    private CePointMapper cePointMapper;

    @Override
    public CePointPageDto getCePointList(CePointPageRequest cePointPageRequest) {
        Page<CePoint> page = new Page<>(cePointPageRequest.getPageNumber(),cePointPageRequest.getPageSize());
        // 获取数据
        IPage<CePoint> cePointIPage = cePointMapper.selectCePointPage(page, cePointPageRequest);
        List<CePoint> records = cePointIPage.getRecords();
        long total = cePointIPage.getTotal();
        // 数据拷贝
        CePointPageDto cePointPageDto = new CePointPageDto();
        List<CePointDto> cePointDtoList = new ArrayList<>();
        for (CePoint record : records) {
            CePointDto cePointDto = new CePointDto();
            BeanUtils.copyProperties(record,cePointDto);
            cePointDtoList.add(cePointDto);
        }
        cePointPageDto.setCePointDtoList(cePointDtoList);
        cePointPageDto.setTotal(total);
        return cePointPageDto;
    }
}




