package com.gaea.iesms.bm.archive.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gaea.base.core.R;
import com.gaea.base.error.BizException;
import com.gaea.base.vo.PageDataVo;
import com.gaea.iesms.bm.archive.mapper.CeResourceSortMapper;
import com.gaea.iesms.bm.archive.model.request.ceResourceSort.AddCeResourceSortRequest;
import com.gaea.iesms.bm.archive.model.request.ceResourceSort.QueryCeResourceSortRequest;
import com.gaea.iesms.bm.archive.model.request.ceResourceSort.UpdateCeResourceSortRequest;
import com.gaea.iesms.bm.archive.model.response.dto.ceResourceSort.CeResourceSortDto;
import com.gaea.iesms.bm.archive.service.CeResourceSortService;
import com.gaea.iesms.core.feign.request.SysCodeRequest;
import com.gaea.iesms.core.feign.response.system.SysCodeVo;
import com.gaea.iesms.core.feign.service.RemoteSystemService;
import com.gaea.iesms.core.model.entity.archive.CeResourceSort;
import com.gaea.iesms.core.model.entity.archive.ValueListVo;
import com.gaea.iesms.core.model.jsonobject.archive.TemplatePropsJsonObject;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * @author Administrator
 * @description 针对表【ce_resource_sort(用能资源分类（自动配置）)】的数据库操作Service实现
 * @createDate 2023-04-11 10:26:43
 */
@Service
public class CeResourceSortServiceImpl extends ServiceImpl<CeResourceSortMapper, CeResourceSort>
        implements CeResourceSortService {

    @Resource
    private CeResourceSortMapper ceResourceSortMapper;

    @Resource
    private RemoteSystemService sysCodeService;

    @Override
    public Integer addCeResourceSort(AddCeResourceSortRequest ceResourceSortAddRequest) {
        CeResourceSort ceResourceSort = new CeResourceSort();
        BeanUtils.copyProperties(ceResourceSortAddRequest, ceResourceSort);
        int insert = ceResourceSortMapper.insert(ceResourceSort);
        return insert;
    }

    @Override
    public Integer removeCeResourceSortById(String id) {
        return ceResourceSortMapper.deleteById(id);
    }

    @Override
    public Integer updateCeResourceSort(UpdateCeResourceSortRequest ceResourceSortUpdateRequest) {
        CeResourceSort ceResourceSort = new CeResourceSort();
        BeanUtils.copyProperties(ceResourceSortUpdateRequest, ceResourceSort);
        return ceResourceSortMapper.updateById(ceResourceSort);
    }

    @Override
    public CeResourceSortDto queryCeResourceSortById(String id) {
        // 验证id是否为空
        if (StrUtil.isEmpty(id)) {
            throw BizException.of("分类id不能为空");
        }

        // 构建查询条件，查询资源分类信息
        LambdaQueryWrapper<CeResourceSort> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(CeResourceSort::getId, id);
        CeResourceSort ceResourceSort = getOne(lambdaQueryWrapper);

        // 将查询到的资源分类信息转换为DTO对象
        CeResourceSortDto ceResourceSortDto = new CeResourceSortDto();
        BeanUtils.copyProperties(ceResourceSort, ceResourceSortDto);
        ceResourceSortDto.setCeResSortNoId(String.valueOf(ceResourceSort.getId()));

        // 处理模板属性，转换为前端可识别的格式
        List<TemplatePropsJsonObject> templateProps = ceResourceSortDto.getTemplateProps();
        if (CollectionUtil.isNotEmpty(templateProps)) {
            List<TemplatePropsJsonObject> templateProps2 = new ArrayList<>();
            for (Object object : templateProps) {
                String s = JSONUtil.toJsonStr(object);
                TemplatePropsJsonObject templateProp = JSONUtil.toBean(s, TemplatePropsJsonObject.class);
                // 如果存在代码排序号，则查询并设置对应的值列表
                if (StrUtil.isNotEmpty(templateProp.getCodeSortNo())) {
                    SysCodeRequest request = new SysCodeRequest();
                    request.setPageNumber(-1);
                    request.setPageSize(-1);
                    request.setParentId(3L);
                    request.setCodeSortNo(templateProp.getCodeSortNo());
                    R<PageDataVo<SysCodeVo>> list = sysCodeService.list(request);
                    Collection<SysCodeVo> records = list.getData().getRecords();
                    List<ValueListVo> valueList = templateProp.getValueList();
                    for (SysCodeVo record : records) {
                        ValueListVo valueListVo = new ValueListVo();
                        valueListVo.setKey(record.getCodeValue());
                        valueListVo.setName(record.getCodeName());
                        valueList.add(valueListVo);
                    }
                    // 判断是否设置默认值
                    boolean hasDefaultValue = templateProp.isHasDefaultValue();
                    if (hasDefaultValue) {
                        templateProp.setValue(valueList.get(0).getKey());
                    }
                }
                templateProps2.add(templateProp);
            }
            ceResourceSortDto.setTemplateProps(templateProps2);
        }
        return ceResourceSortDto;
    }


    @Override
    public List<CeResourceSortDto> queryCeResourceSortByCeResClass(QueryCeResourceSortRequest queryCeResourceSortRequest) {
        LambdaQueryWrapper<CeResourceSort> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper
                .eq(queryCeResourceSortRequest.getCeResClass() != null, CeResourceSort::getCeResClass, queryCeResourceSortRequest.getCeResClass())
                .eq(StrUtil.isNotEmpty(queryCeResourceSortRequest.getCeResType()), CeResourceSort::getCeResType, queryCeResourceSortRequest.getCeResType())
                .eq(StrUtil.isNotEmpty(queryCeResourceSortRequest.getCeResSortNo()), CeResourceSort::getCeResSortNo, queryCeResourceSortRequest.getCeResSortNo());

        List<CeResourceSort> ceResourceSorts = ceResourceSortMapper.selectList(queryWrapper);

        List<CeResourceSortDto> dtoList = new ArrayList<>();
        for (CeResourceSort ceResourceSort : ceResourceSorts) {
            CeResourceSortDto ceResourceSortDto = new CeResourceSortDto();
            BeanUtils.copyProperties(ceResourceSort, ceResourceSortDto);
            dtoList.add(ceResourceSortDto);
        }
        return dtoList;
    }
}




