package com.gaea.iesms.bm.archive.controller;

import com.gaea.base.core.R;
import com.gaea.base.enums.HandleCodeEnum;
import com.gaea.iesms.bm.archive.model.request.ceResourceDetail.AddCeResourceDetailRequest;
import com.gaea.iesms.bm.archive.model.request.ceResourceDetail.GetLowerCeResSortRequest;
import com.gaea.iesms.bm.archive.model.request.ceResourceDetail.UpdateCeResourceDetailRequest;
import com.gaea.iesms.bm.archive.model.response.dto.ceResourceDetail.CeResourceDetailDto;
import com.gaea.iesms.bm.archive.model.response.vo.ceResourceDetail.CeResourceDetailVo;
import com.gaea.iesms.bm.archive.model.response.vo.ceResourceDetail.LowerCeResSortVo;
import com.gaea.iesms.bm.archive.service.CeResourceDetailService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author Administrator
 * @version 1.0
 * @description: 用能资源树明细 管理
 * @date 2023/4/11 15:55
 */
@RestController
@RequestMapping("/ceResourceDectail")
@Api(tags = "用能资源树明细管理")
public class CeResourceDetailController {

    @Resource
    private CeResourceDetailService ceResourceDetailService;

    /**
     * 增加用能资源树明细
     *
     * @param addCeResourceDetailRequest
     * @author: JIE
     * @date: 2023/4/11 15:57
     */
    @ApiOperation(value = "增加用能资源树明细")
    @PostMapping("/addCeResourceDetail")
    public R addCeResourceDetail(@RequestBody AddCeResourceDetailRequest addCeResourceDetailRequest) {
        Integer integer = ceResourceDetailService.addCeResourceDetail(addCeResourceDetailRequest);
        if (integer > 0) {
            return R.enums(HandleCodeEnum.INSERT_SUCCESS);
        }
        return R.enums(HandleCodeEnum.INSERT_ERROR);
    }

    /**
     * 删除用能资源树明细
     *
     * @param id 用能资源树明细ID
     * @author: JIE
     * @date: 2023/4/11 15:59
     */
    @ApiImplicitParam(name = "id", value = "用能资源树明细ID", required = true, dataType = "String")
    @ApiOperation(value = "删除用能资源树明细")
    @DeleteMapping("/removeCeResourceDetail")
    public R removeCeResourceDetail(String id) {
        Integer integer = ceResourceDetailService.removeCeResourceDetail(id);
        if (integer > 0) {
            return R.enums(HandleCodeEnum.DELETE_SUCCESS);
        }
        return R.enums(HandleCodeEnum.DELETE_ERROR);
    }

    /**
     * 修改用能资源树明细
     *
     * @param updateCeResourceDetailRequest
     * @author: JIE
     * @date: 2023/4/11 15:57
     */
    @ApiOperation(value = "修改用能资源树明细")
    @PutMapping("/removeCeResourceDetail")
    public R updateCeResourceDetail(UpdateCeResourceDetailRequest updateCeResourceDetailRequest) {
        Integer integer = ceResourceDetailService.updateCeResourceDetail(updateCeResourceDetailRequest);
        if (integer > 0) {
            return R.enums(HandleCodeEnum.HANDLE_SUCCESS);
        }
        return R.enums(HandleCodeEnum.HANDLE_ERROR);
    }

    /**
     * 根据用能资源树ID查询用能资源树明细
     *
     * @param id 用能资源树ID
     * @return: CeResourceDetailDto
     * @author: JIE
     * @date: 2023/4/11 16:06
     */
    @ApiOperation(value = "根据用能资源树ID查询用能资源树明细")
    @ApiImplicitParam(name = "id", value = "用能资源树明细ID", required = true, dataType = "String")
    @GetMapping("/getCeResourceDetailById")
    public R<CeResourceDetailVo> getCeResourceDetail(String id) {
        CeResourceDetailDto ceResourceDetailById = ceResourceDetailService.getCeResourceDetailById(id);
        CeResourceDetailVo ceResourceDetailVo = new CeResourceDetailVo();
        BeanUtils.copyProperties(ceResourceDetailById, ceResourceDetailVo);
        return R.ok(ceResourceDetailVo);
    }

    @ApiOperation(value = "获取下级用能资源分类信息")
    @GetMapping("/getLowerCeResSort")
    public R<List<LowerCeResSortVo>> getLowerCeResSort(GetLowerCeResSortRequest request) {
        List<LowerCeResSortVo> lowerCeResSort = ceResourceDetailService.getLowerCeResSort(request);
        return R.ok(lowerCeResSort);
    }

}
