package com.gaea.iesms.bm.archive.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gaea.iesms.core.feign.request.archive.QueryUserRequest;
import com.gaea.iesms.core.feign.request.archive.UserPageRequest;
import com.gaea.iesms.bm.archive.model.response.dto.ceCust.CeCustDto;
import com.gaea.iesms.bm.archive.model.response.dto.ceResource.EnergyResourceTypeDto;
import com.gaea.iesms.core.model.entity.archive.CeCust;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;


/**
 * @author JIE
 * @description 针对表【ce_cust(用能客户 用能资源子表)】的数据库操作Mapper
 * @createDate 2023-02-20 09:01:25
 * @Entity com.gaea.iesms.core.model.entity.archive.CeCust
 */
@Mapper
public interface CeCustMapper extends BaseMapper<CeCust> {

    /**
     * 根据条件查询单个用户档案
     *
     * @param: queryUserRequest 查询条件
     * @return: com.gaea.iesms.bm.archive.model.response.dto.ceCust.CeCustDto
     * @author JIE
     * @date: 2024/2/26 14:44
     */
    CeCustDto queryUserFileAccordConduit(QueryUserRequest queryUserRequest);

    /**
     * 查询所有用户档案
     *
     * @param: userPageRequest 查询参数
     * @param: page 分页参数
     * @return: com.baomidou.mybatisplus.core.metadata.IPage<com.gaea.iesms.bm.archive.model.response.dto.ceCust.CeCustDto>
     * @author JIE
     * @date: 2024/2/26 14:43
     */
    IPage<CeCustDto> listPagedUserProfiles(@Param("param") UserPageRequest userPageRequest,
                                           @Param("page") Page<CeCustDto> page);

    /**
     * 查询用户用能资源信息
     *
     * @param: orgNo 单位编号
     * @return: java.util.List<com.gaea.iesms.bm.archive.model.response.dto.ceResource.EnergyResourceTypeDto>
     * @author JIE
     * @date: 2024/2/26 14:47
     */
    List<EnergyResourceTypeDto> listEnergyResourceTypeDto(@Param("orgNo") String orgNo);
}




