package com.gaea.iesms.bm.archive.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gaea.iesms.bm.archive.model.request.cePart.CePartByResClassAndTypeQueryRequest;
import com.gaea.iesms.bm.archive.model.request.cePart.QueryPartRequest;
import com.gaea.iesms.bm.archive.model.response.dto.cePart.CePartDto;
import com.gaea.iesms.bm.archive.model.response.dto.ceResource.EnergyResourceTypeDto;
import com.gaea.iesms.core.model.entity.archive.CePart;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author JIE
 * @description 针对表【ce_part(用能区域 用能资源子表)】的数据库操作Mapper
 * @createDate 2023-02-20 09:36:41
 * @Entity com.gaea.iesms.core.model.entity.archive.CePart
 */
@Mapper
public interface CePartMapper extends BaseMapper<CePart> {

    /**
     * 查询所有用能区域档案
     *
     * @param: queryPartRequest
     * @return: java.util.List<com.gaea.iesms.bm.archive.model.response.dto.cePart.CePartDto>
     * @author JIE
     * @date: 2024/2/26 11:29
     */
    List<CePartDto> listAllEnergyRegions(QueryPartRequest queryPartRequest);

    /**
     * 根据用能资源类别和用能资源类型 获取用能区域
     *
     * @param request 请求参数
     * @return: 用能区域集合
     * @author: JIE
     * @date: 2023/4/12 16:19
     */
    List<EnergyResourceTypeDto> queryCePartByCeResClassAndCeResType(CePartByResClassAndTypeQueryRequest request);

    /**
     * 查询所有区域档案
     *
     * @param: page 分页参数
     * @return: com.baomidou.mybatisplus.core.metadata.IPage<com.gaea.iesms.bm.archive.model.response.dto.cePart.CePartDto>
     * @author JIE
     * @date: 2024/2/26 11:28
     */
    IPage<CePartDto> listPagedEnergyRegions(@Param("page") Page<CePartDto> page);
}




