package com.gaea.iesms.bm.archive.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.gaea.iesms.core.feign.request.archive.QueryMicConfigRequest;
import com.gaea.iesms.core.feign.dto.QueryCeResourceMicConfigDto;
import com.gaea.iesms.core.model.entity.archive.CeResourceMicConfig;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 用能资源量测项编码配置
 *
 * @author JIE
 * @version 1.0
 * @date 2023/12/1 16:15
 */
@Mapper
public interface CeResourceMicConfigMapper extends BaseMapper<CeResourceMicConfig> {

    /**
     * 查询右边配置量测项
     *
     * @param: request 请求参数
     * @return: com.gaea.bm.ems.model.dto.QueryCeResourceMicConfigDto
     * @author JIE
     * @date: 2023/12/4 9:31
     */
    List<QueryCeResourceMicConfigDto> queryCeResourceMicConfig(QueryMicConfigRequest request);

    /**
     * 物理删除量测项配资
     *
     * @param: ceResId
     * @return: int
     * @author JIE
     * @date: 2023/12/4 17:32
     */
    int deleteByCeResId(@Param("ceResId") Long ceResId);
}