package com.gaea.iesms.bm.archive.mapper.headle;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.gaea.spring.cloud.starter.util.AuthUtils;
import org.apache.ibatis.reflection.MetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/11/23
 */
public class EntityMetaObjectHandler implements MetaObjectHandler {

    private static final Logger LOGGER = LoggerFactory.getLogger(EntityMetaObjectHandler.class);

    @Override
    public void insertFill(MetaObject metaObject) {
        if(LOGGER.isDebugEnabled()) {
            LOGGER.debug("start insert fill ....");
        }
        this.strictInsertFill(metaObject, "sortSn", Integer.class, 1);
        this.strictInsertFill(metaObject, "isValid", Boolean.class, true);
        this.strictInsertFill(metaObject, "creator", String.class, AuthUtils.getUserNo());
        this.strictInsertFill(metaObject, "gmtCreate", Long.class, System.currentTimeMillis());
        this.strictInsertFill(metaObject, "modifier", String.class, "");
        this.strictInsertFill(metaObject, "gmtModified", Long.class, 0L);
        this.strictInsertFill(metaObject, "invalider", String.class, "");
        this.strictInsertFill(metaObject, "gmtInvalid", Long.class, 0L);
        this.strictInsertFill(metaObject, "version", Integer.class, 1);
    }

    @Override
    public void updateFill(MetaObject metaObject) {
        if(LOGGER.isDebugEnabled()) {
            LOGGER.debug("start update fill ....");
        }
        this.strictUpdateFill(metaObject, "modifier", String.class, AuthUtils.getUserNo());
        this.strictUpdateFill(metaObject, "gmtModified", Long.class, System.currentTimeMillis());
    }
}
