package com.gaea.iesms.bm.archive.model.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 批量添加用能资源量测项编码配置请求类
 *
 * @author JIE
 * @version 1.0
 * @date 2023/12/1 16:22
 */
@ApiModel("批量添加用能资源量测项编码配置请求类")
@Data
public class BatchAddConfigRequest {

    /**
     * 用能资源id
     */
    @NotNull(message = "用能资源id不能为空")
    @ApiModelProperty("用能资源id")
    private String id;

    /**
     * 量测项编码
     */
    @ApiModelProperty("量测项编码")
    private List<String> measItemCode;
}
