package com.gaea.iesms.bm.archive.model.request.ceCust;

import com.gaea.iesms.core.model.enums.archive.CeCustTypeEnum;
import com.gaea.iesms.core.model.enums.archive.CeResClassEnum;
import com.gaea.iesms.core.model.enums.archive.CeResStatusEnum;
import com.gaea.iesms.core.model.jsonobject.archive.CeCustBizpropsJsonObject;
import com.gaea.iesms.core.model.jsonobject.archive.CeCustPropsJsonObject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 用户请求类
 *
 * @author: JIE
 * @Date: 2023/03/07/16:27
 */
@ApiModel(description = "用户请求类")
@Data
public class CeCustRequest {

    /**
     * 用能资源标识 SnowflakeId
     */
    @ApiModelProperty(value = "用能资源标识 SnowflakeId")
    private Long id;

    /**
     * 用能客户类型
     *
     * @see CeCustTypeEnum
     */
    @ApiModelProperty(value = "用能客户类型 1 - 企业；2 - 个人；11 - 公用配电台区；12 - 分布式光伏电站；41 - 热力站")
    private Integer ceCustType;

    /**
     * 用能客户证件号码
     */
    @ApiModelProperty(value = "用能客户证件号码")
    private String ceCustCredNo;

    /**
     * 用能客户证件附件
     */
    @ApiModelProperty(value = "用能客户证件附件")
    private String ceCustCredAttach;

    /**
     * 用能客户地址
     */
    @ApiModelProperty(value = "用能客户地址")
    private String ceCustAddr;

    /**
     * 用能客户属性集
     */
    @ApiModelProperty(value = "用能客户属性集")
    private CeCustPropsJsonObject ceCustProps;

    /**
     * 用能客户业务属性集
     */
    @ApiModelProperty(value = "用能客户业务属性集")
    private CeCustBizpropsJsonObject ceCustBizprops;

    /**
     * 行业分类
     */
    @ApiModelProperty(value = "行业分类")
    private String tradeCode;

    /**
     * 区域编码
     */
    @ApiModelProperty(value = "区域编码")
    private String adcode;

    /**
     * 城市编码
     */
    @ApiModelProperty(value = "城市编码")
    private String citycode;

    /**
     * 经度
     */
    @ApiModelProperty(value = "经度")
    private BigDecimal longitude;

    /**
     * 纬度
     */
    @ApiModelProperty(value = "纬度")
    private BigDecimal latitude;

    /**
     * 用能资源类别 1 - 用能客户；
     * 2 - 用能区域；
     * 3 - 用能容器；
     * 4 - 用能设备;
     *
     * @see CeResClassEnum
     */
    @ApiModelProperty(value = "用能资源类别 1 - 用能客户； 2 - 用能区域； 3 - 用能容器； 4 - 用能设备；")
    private Integer ceResClass;

    /**
     * 用能资源编号
     */
    @ApiModelProperty(value = "用能资源编号")
    private String ceResNo;

    /**
     * 用能资源状态 编码CE_RES_STATUS：
     *
     * @see CeResStatusEnum
     */
    @ApiModelProperty(value = "用能资源状态 编码CE_RES_STATUS：10 – 未投运； 20 – 投运； 30 – 暂停；40 – 退运； ")
    private String ceResStatus;

    /**
     * 用能资源名称
     */
    @ApiModelProperty(value = "用能资源名称")
    private String ceResName;

    /**
     * 用能资源简称
     */
    @ApiModelProperty(value = "用能资源简称")
    private String ceResAbbr;

    /**
     * 用能资源说明
     */
    @ApiModelProperty(value = "用能资源说明")
    private String ceResDesc;

    /**
     * 用电容量
     */
    @ApiModelProperty(value = "用电容量")
    private BigDecimal elecCapacity;

    /**
     * 电压等级 编码CE_VOLTAGE_CLASS
     */
    @ApiModelProperty(value = "电压等级 编码CE_VOLTAGE_CLASS")
    private String voltageClass;

}
