package com.gaea.iesms.bm.archive.model.response.dto.ceContainer;

import com.gaea.iesms.core.model.entity.archive.CeResourceProps;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 用能容器档案信息
 *
 * @author JIE
 */
@Data
public class CeContainerDto implements Serializable {
    /**
     * 用能资源标识 SnowflakeId
     */
    private Long id;

    /**
     * 用能资源（容器）分类编号 见用能资源分类表
     */
    private String ceResSortNo;

    /**
     * 用能资源分类id
     */
    private String ceResSortNoId;

    /**
     * 上级用能资源类别 1 - 用能客户；
     * 2 - 用能区域；
     * 3 - 用能容器；
     */
    private Integer parentCeResClass;

    /**
     * 上级用能资源标识
     */
    private Long parentCeResId;

    /**
     * 用能客户标识
     */
    private Long ceCustId;

    /**
     * 用能区域标识 如果上级用能资源类别位1 – 用能客户，则该字段为0
     */
    private Long cePartId;

    /**
     * 上级用能容器标识 如果上级用能资源类别位1 – 用能客户 或 2 – 用能区域，则该字段为0
     */
    private Long parentId;

    /**
     * 用能容器属性集
     */
    private CeResourceProps ceCntrProps;

    /**
     * 系统单位编号
     */
    private String orgNo;

    /**
     * 用能资源类别 1 - 用能客户；
     * 2 - 用能区域；
     * 3 - 用能容器；
     * 4 - 用能设备；
     */
    private Integer ceResClass;

    /**
     * 用能资源编号
     */
    private String ceResNo;

    /**
     * 用能资源状态 编码CE_RES_STATUS：
     * 10 – 未投运；
     * 20 – 投运；
     * 30 – 暂停；
     * 40 – 退运；
     */
    private String ceResStatus;


    /**
     * 用能资源名称
     */
    private String ceResName;

    /**
     * 用能资源简称
     */
    private String ceResAbbr;

    /**
     * 用能资源说明
     */
    private String ceResDesc;

    /**
     * 用电容量
     */
    private BigDecimal elecCapacity;

    /**
     * 电压等级 编码CE_VOLTAGE_CLASS
     */
    private String voltageClass;

    /**
     * 排序序号
     */
    private Integer sortSn;

    /**
     * 是否有效
     */
    private Boolean isValid;

    /**
     * 创建人 系统用户表用户编号字段（user_no）
     */
    private String creator;

    /**
     * 创建时间 为0表示为空
     */
    private Long gmtCreate;

    /**
     * 更新人 系统用户表用户编号字段（user_no）
     */
    private String modifier;

    /**
     * 更新时间 为0表示为空
     */
    private Long gmtModified;

    /**
     * 失效人 系统用户表用户编号字段（user_no）
     */
    private String invalider;

    /**
     * 失效时间 为0表示为空
     */
    private Long gmtInvalid;

    /**
     * 版本号 用于乐观锁
     */
    private Integer version;

    private static final long serialVersionUID = 1L;
}
