package com.gaea.iesms.bm.archive.model.response.vo.ceResource;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author JIE
 * @version 1.0
 * @description: 用能资源
 * @date 2023/4/4 16:53
 */
@Data
@ApiModel("用能资源")
public class EnergyResourceVo implements Serializable {

    /**
     * 用能资源id
     */
    @ApiModelProperty(value = "用能资源id")
    private Long id;

    /**
     * 用能资源名称
     */
    @ApiModelProperty(value = "用能资源名称")
    private String ceResName;

    /**
     * 用能资源类型
     */
    @ApiModelProperty("用能资源类型 源：source" +
            "网：net" +
            "荷：eload" +
            "储：stroe" +
            "充：charge")
    private String ceResType;

    /**
     * 用能资源类型
     *
     * @see com.gaea.iesms.core.model.enums.archive.CeResClassEnum
     */
    @ApiModelProperty(value = "用能资源类别 1、用能客户 2、用能区域 3、 用能容器 4、用能设备")
    private Integer ceResClass;

    /**
     * 用能资源分类编号
     */
    @ApiModelProperty(value = "用能资源分类编号")
    private String ceResSortNo;

    /**
     * 是否拥有树节点
     */
    @ApiModelProperty(value = "是否拥有树节点")
    private Boolean hasChildren;

    /**
     * 排序序号
     */
    @ApiModelProperty(value = "排序序号")
    private Integer sortSn;
}
