package com.gaea.iesms.bm.archive.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.gaea.iesms.bm.archive.model.request.cePart.CePartRequest;
import com.gaea.iesms.core.feign.request.archive.EnergyRegionPageRequest;
import com.gaea.iesms.bm.archive.model.request.cePart.UpdateCePartRequest;
import com.gaea.iesms.bm.archive.model.response.dto.cePart.CePartPageDto;
import com.gaea.iesms.core.feign.response.archive.CePartVo;
import com.gaea.iesms.core.model.entity.archive.CePart;

/**
 * 针对表【ce_part(用能区域 用能资源子表)】的数据库操作Service
 *
 * @author JIE
 * @createDate 2023-02-20 09:36:41
 */
public interface CePartService extends IService<CePart> {

    /**
     * 增加用能区域
     *
     * @param cePartRequest 请求参数
     * @return 主键id
     * @author JIE
     * @date: 2023/11/10 17:08
     */
    String addCePart(CePartRequest cePartRequest);

    /**
     * 根据用能区域档案id修改用能区域
     *
     * @param request 请求参数
     * @return true 成功 false 失败
     * @author JIE
     * @date: 2023/11/10 17:32
     */
    Boolean updateEnergyRegionByArchiveId(UpdateCePartRequest request);

    /**
     * 查询单个用能区域档案详细信息
     *
     * @param id 用能区域档案id
     * @return CePartDto
     * @author JIE
     * @date: 2023/11/10 17:33
     */
    CePartVo getEnergyRegionDetailByArchiveId(String id);

    /**
     * 查询所有用能区域档案列表
     *
     * @param: energyRegionPageRequest
     * @return: 所有用能区域档案分页
     * @author: JIE
     * @date: 2023/3/20 15:18
     */
    CePartPageDto listPagedEnergyRegions(EnergyRegionPageRequest energyRegionPageRequest);
}
