package com.gaea.iesms.bm.archive.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.gaea.iesms.bm.archive.model.request.ceResourceDetail.AddCeResourceDetailRequest;
import com.gaea.iesms.bm.archive.model.request.ceResourceDetail.GetCeResourceDetailRequest;
import com.gaea.iesms.bm.archive.model.request.ceResourceDetail.GetLowerCeResSortRequest;
import com.gaea.iesms.bm.archive.model.request.ceResourceDetail.UpdateCeResourceDetailRequest;
import com.gaea.iesms.bm.archive.model.response.dto.ceResourceDetail.CeResourceDetailDto;
import com.gaea.iesms.bm.archive.model.response.vo.ceResourceDetail.LowerCeResSortVo;
import com.gaea.iesms.core.model.entity.archive.CeResourceDetail;

import java.util.List;

/**
 * @author Administrator
 * @description 针对表【ce_resource_detail(用能资源树明细 )】的数据库操作Service
 * @createDate 2023-04-11 14:35:45
 */
public interface CeResourceDetailService extends IService<CeResourceDetail> {

    /**
     * 增加用能资源树明细
     *
     * @param addCeResourceDetailRequest
     * @return: 1、成功 0、失败
     * @author: JIE
     * @date: 2023/4/11 15:57
     */
    Integer addCeResourceDetail(AddCeResourceDetailRequest addCeResourceDetailRequest);

    /**
     * 删除用能资源树明细
     *
     * @param id 用能资源树明细ID
     * @return: 1、成功 0、失败
     * @author: JIE
     * @date: 2023/4/11 15:59
     */
    Integer removeCeResourceDetail(String id);

    /**
     * 修改用能资源树明细
     *
     * @param updateCeResourceDetailRequest
     * @return: 1、成功 0、失败
     * @author: JIE
     * @date: 2023/4/11 15:57
     */
    Integer updateCeResourceDetail(UpdateCeResourceDetailRequest updateCeResourceDetailRequest);

    /**
     * 根据用能资源树ID查询用能资源树明细
     *
     * @param id 用能资源树ID
     * @return: CeResourceDetailDto
     * @author: JIE
     * @date: 2023/4/11 16:06
     */
    CeResourceDetailDto getCeResourceDetailById(String id);

    /**
     * 根据上级资源查询下级资源树明细
     *
     * @param: request
     * @return: java.util.List<com.gaea.iesms.bm.archive.model.response.dto.ceResourceDetail.CeResourceDetailDto>
     * @author JIE
     * @date: 2024/1/31 15:30
     */
    List<CeResourceDetailDto> querySubResourcesBySuperResource(GetCeResourceDetailRequest request);

    /**
     * 获取下级用能资源分类信息
     *
     * @param request 请求参数
     * @return List<LowerCeResSortVo>
     * @author JIE
     * @date: 2023/11/8 14:54
     */
    List<LowerCeResSortVo> getLowerCeResSort(GetLowerCeResSortRequest request);
}
