package com.gaea.iesms.bm.archive.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.gaea.iesms.bm.archive.model.request.ceResource.EnergyResourceTreeRequest;
import com.gaea.iesms.bm.archive.model.request.ceResource.EnergyResourceTreeVo;
import com.gaea.iesms.bm.archive.model.response.vo.ResourceVo;
import com.gaea.iesms.core.model.entity.archive.CeResource;

import java.util.List;

/**
 * 针对表【ce_resource(用能资源 )】的数据库操作Service
 *
 * @author JIE
 * @createDate 2023-02-15 17:25:43
 */
public interface CeResourceService extends IService<CeResource> {

    /**
     * 增加用能资源
     *
     * @param: ceResource
     * @param: ceResSortNo
     * @return: java.lang.Boolean
     * @author JIE
     * @date: 2024/1/31 10:38
     */
    Boolean addCeResource(CeResource ceResource, String ceResSortNo);

    /**
     * 增加用能资源(虚拟电厂特供)
     *
     * @param: ceResource
     * @param: ceResSortNo
     * @return: java.lang.Boolean
     * @author JIE
     * @date: 2024/1/31 10:38
     */
    Boolean addVppCeResource(CeResource ceResource);

    /**
     * 删除用能资源
     *
     * @param ids 用能资源主键ID
     * @return true 成功 false 失败
     * @author JIE
     * @date: 2023/11/24 10:21
     */
    Boolean deleteResourcesById(List<String> ids);

    /**
     * 修改用能资源
     *
     * @param ceResource  用能资源
     * @param ceResSortNo 用能资源分类编号
     * @return true 成功 false 失败
     * @author JIE
     * @date: 2023/11/27 10:47
     */
    Boolean updateCeResource(CeResource ceResource, String ceResSortNo);

    /**
     * 获取用能资源树
     *
     * @param request 请求参数
     * @return:
     * @author: JIE
     * @date: 2023/7/17 9:10
     */
    List<EnergyResourceTreeVo> getMicrogridSpatialStructure(EnergyResourceTreeRequest request);

    /**
     * 获取用能资源树（一次性加载）
     *
     * @param request 请求参数
     * @return: java.util.List<com.gaea.bm.ems.model.vo.ceresource.EnergyResourceTreeVo>
     * @author 阿杰 2416338031@qq.com
     * @date: 2023/12/7 13:40
     */
    List<EnergyResourceTreeVo> getEnergyResourceTree(EnergyResourceTreeRequest request);

    /**
     * 搜索用能资源
     *
     * @param keyWord 搜索关键词
     * @return List<ResourceVo>
     * @author JIE
     * @date: 2023/11/20 17:16
     */
    List<ResourceVo> searchEnergyResources(String keyWord);

    /**
     * 获取用能资源层级信息
     *
     * @param id 用能资源主键ID
     * @return List<String>
     * @author JIE
     * @date: 2023/11/24 18:15
     */
    List<String> getEnergyResourceHierarchy(String id);
}
