package com.gaea.iesms.bm.archive.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.fasterxml.jackson.databind.JsonNode;
import com.gaea.base.core.R;
import com.gaea.base.error.BizException;
import com.gaea.iesms.bm.archive.mapper.CePartMapper;
import com.gaea.iesms.bm.archive.model.request.cePart.CePartRequest;
import com.gaea.iesms.bm.archive.model.request.cePart.UpdateCePartRequest;
import com.gaea.iesms.bm.archive.model.response.dto.cePart.CePartDto;
import com.gaea.iesms.bm.archive.model.response.dto.cePart.CePartPageDto;
import com.gaea.iesms.bm.archive.model.response.dto.ceResourceSort.CeResourceSortDto;
import com.gaea.iesms.bm.archive.service.*;
import com.gaea.iesms.core.feign.request.archive.EnergyRegionPageRequest;
import com.gaea.iesms.core.feign.response.archive.CePartVo;
import com.gaea.iesms.core.feign.service.RemoteIotService;
import com.gaea.iesms.core.model.entity.archive.*;
import com.gaea.iesms.core.model.entity.iot.GmDevMeter;
import com.gaea.iesms.core.model.enums.archive.CeResClassEnum;
import com.gaea.iesms.core.model.jsonobject.archive.CePointPropsJsonObject;
import com.gaea.spring.cloud.starter.util.AuthUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

import static com.gaea.iesms.core.model.entity.archive.factory.CeResourcePropsFactory.createResourceData;

/**
 * @author Administrator
 * @description 针对表【ce_part(用能区域 用能资源子表)】的数据库操作Service实现
 * @createDate 2023-02-20 09:36:41
 */
@Slf4j
@Service
public class CePartServiceImpl extends ServiceImpl<CePartMapper, CePart>
        implements CePartService {

    @Resource
    private RemoteIotService remoteIotService;

    @Resource
    private CePartMapper cePartMapper;

    @Resource
    private CeResourceService ceResourceService;

    @Resource
    private CePointService cePointService;

    @Resource
    private CePointMeterService cePointMeterService;

    @Resource
    private CeResourceSortService ceResourceSortService;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public String addCePart(CePartRequest cePartRequest) {

        // 1、新增用能区域表
        String orgNo = AuthUtils.getOrgNo();
        cePartRequest.setOrgNo(orgNo);
        CePart cePart = new CePart();
        BeanUtils.copyProperties(cePartRequest, cePart);
        cePart.setCeCustId(cePartRequest.getParentCeResId());
        CeResourceProps resourceData = createResourceData(cePartRequest.getCeResSortNo());
        cePart.setCePartProps(resourceData.savaConvertFields(cePartRequest.getCeResourceProps()));
        cePart.setCeResSortNoId(cePartRequest.getCeResSortNoId());
        save(cePart);

        // 2、将一些公共的字段从json里面抽取出来
        JsonNode ceResourceProps = cePartRequest.getCeResourceProps();
        String ceResName = ceResourceProps.get("ceResName").asText();
        JsonNode sortSn1 = ceResourceProps.get("sortSn");
        String sortSn = sortSn1 == null || "".equals(sortSn1.asText()) || "null".equals(sortSn1.asText()) ? "1" : sortSn1.asText();
        JsonNode ceResNo1 = ceResourceProps.get("ceResNo");
        String ceResNo = ceResNo1 == null ? "" : ceResNo1.asText();
        // 获取关联表计
        JsonNode correlTableMeter = ceResourceProps.get("correlTableMeter");
        // 转换成List
        // 将correlTableMeter 转为 LIST<Long>
        List<String> meterList = new ArrayList<>();
        if (correlTableMeter != null) {
            if (correlTableMeter.isArray()) {
                for (Iterator<JsonNode> it = correlTableMeter.elements(); it.hasNext(); ) {
                    meterList.add(it.next().asText());
                }
            }
        }

        // 3、新增用能点
        CePoint cePoint = new CePoint();
        cePoint.setOrgNo(orgNo);
        cePoint.setCeCustId(cePart.getCeCustId());
        cePoint.setCeResId(cePart.getId());
        cePoint.setCeResClass(2);
        cePoint.setCePointLevel(1);
        cePoint.setCePointNo(ceResNo);
        if (StrUtil.isBlank(ceResNo)) {
            cePoint.setCePointNo(String.valueOf(cePart.getId()));
        }
        cePoint.setCePointName(ceResName);
        cePoint.setIsSettlement(0);
        // 设置用能类型
        CeResourceSortDto ceResourceSortDto = ceResourceSortService.queryCeResourceSortById(cePartRequest.getCeResSortNoId());
        cePoint.setCePointType(ceResourceSortDto.getCeResType());
        cePoint.setParentId(cePart.getCeCustId());
        cePoint.setCePointProps(new CePointPropsJsonObject());
        cePoint.setMeasPointIdList(meterList);
        cePointService.save(cePoint);

        // 4、如果关联表计集合不为空就新增用能点表计关联表
        if (CollectionUtil.isNotEmpty(meterList)) {
            List<CePointMeter> cePointMeters = new ArrayList<>();
            for (String aLong : meterList) {
                CePointMeter cePointMeter = new CePointMeter();
                cePointMeter.setCePointId(cePoint.getId());
                cePointMeter.setDevMeterId(Long.valueOf(aLong));
                cePointMeters.add(cePointMeter);
            }
            cePointMeterService.saveBatch(cePointMeters);
        }

        // 5、新增用能资源表
        CeResource ceResource = new CeResource();
        ceResource.setId(cePart.getId());
        ceResource.setCeResClass(CeResClassEnum.REGION.getValue());
        ceResource.setCeResStatus("20");
        // 设置用能区域名称
        ceResource.setCeResName(ceResName);
        // 设置排序序号
        ceResource.setSortSn(Integer.valueOf(sortSn));
        // 设置用能区域编号
        ceResource.setCeResNo(ceResNo);
        if (StrUtil.isBlank(ceResNo)) {
            ceResource.setCeResNo(String.valueOf(cePart.getId()));
        }
        ceResource.setCeResDesc(ceResName);
        ceResource.setCeResAbbr(ceResName);
        ceResource.setOrgNo(orgNo);
        ceResourceService.addCeResource(ceResource, cePartRequest.getCeResSortNo());
        return ceResource.getId().toString();
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public Boolean updateEnergyRegionByArchiveId(UpdateCePartRequest request) {
        // 1、修改用能区域
        CePart cePart = new CePart();
        BeanUtils.copyProperties(request, cePart);
        CeResourceProps resourceData = createResourceData(request.getCeResSortNo());
        cePart.setCePartProps(resourceData.savaConvertFields(request.getCeResourceProps()));
        cePart.setId(Long.valueOf(request.getId()));
        updateById(cePart);

        // 2、将一些公共的字段从json里面抽取出来
        JsonNode ceResourceProps = request.getCeResourceProps();
        String ceResName = ceResourceProps.get("ceResName").asText();
        JsonNode sortSn1 = ceResourceProps.get("sortSn");
        String sortSn = sortSn1 == null || "".equals(sortSn1.asText()) || "null".equals(sortSn1.asText()) ? "1" : sortSn1.asText();
        JsonNode ceResNo1 = ceResourceProps.get("ceResNo");
        String ceResNo = ceResNo1 == null ? "" : ceResNo1.asText();
        // 获取关联表计
        JsonNode correlTableMeter = ceResourceProps.get("correlTableMeter");
        // 转换成List
        // 将correlTableMeter 转为 LIST<Long>
        List<String> meterList = new ArrayList<>();
        if (correlTableMeter != null) {
            if (correlTableMeter.isArray()) {
                for (Iterator<JsonNode> it = correlTableMeter.elements(); it.hasNext(); ) {
                    meterList.add(it.next().asText());
                }
            }
        }

        // 3、查询用能点
        LambdaQueryWrapper<CePoint> pointQueryWrapper = new LambdaQueryWrapper<>();
        pointQueryWrapper
                .eq(CePoint::getCeResId, request.getId());
        CePoint cePoint = cePointService.getOne(pointQueryWrapper);

        // 4、修改用能点
        cePoint.setCePointNo(ceResNo);
        if (StrUtil.isBlank(ceResNo)) {
            cePoint.setCePointNo(String.valueOf(cePart.getId()));
        }
        cePoint.setCePointName(ceResName);
        cePoint.setMeasPointIdList(meterList);
        cePointService.updateById(cePoint);

        // 5、先删除用能点量测表计关系
        cePointMeterService.removeByCePointIds(Collections.singletonList(cePoint.getId()));

        // 6、重新添加用能点量测表计关系
        if (CollectionUtil.isNotEmpty(meterList)) {
            List<CePointMeter> cePointMeters = new ArrayList<>();
            for (String aLong : meterList) {
                CePointMeter cePointMeter = new CePointMeter();
                cePointMeter.setCePointId(cePoint.getId());
                cePointMeter.setDevMeterId(Long.valueOf(aLong));
                cePointMeters.add(cePointMeter);
            }
            cePointMeterService.saveBatch(cePointMeters);
        }

        // 7、修改用能资源表
        // 设置用能资源
        CeResource ceResource = new CeResource();
        ceResource.setId(cePart.getId());
        // 设置排序序号
        ceResource.setSortSn(Integer.valueOf(sortSn));
        // 设置用能区域编号
        ceResource.setCeResNo(ceResNo);
        if (StrUtil.isBlank(ceResNo)) {
            ceResource.setCeResNo(String.valueOf(cePart.getId()));
        }
        // 设置用能容区域称
        ceResource.setCeResName(ceResName);
        ceResource.setCeResDesc(ceResName);
        ceResource.setCeResAbbr(ceResName);
        if (StrUtil.isBlank(ceResNo)) {
            ceResource.setCeResNo(String.valueOf(cePart.getId()));
        }
        ceResource.setCeResClass(CeResClassEnum.REGION.getValue());
        return ceResourceService.updateCeResource(ceResource, request.getCeResSortNo());
    }

    @Override
    public CePartVo getEnergyRegionDetailByArchiveId(String id) {
        CePart cePart = cePartMapper.selectById(id);
        CeResource ceResource = ceResourceService.getById(id);
        CePartDto cePartDto = new CePartDto();
        BeanUtils.copyProperties(cePart, cePartDto);
        BeanUtils.copyProperties(ceResource, cePartDto);

        // 获取并网关联表记
        CeResourceProps ceDevProps = cePartDto.getCePartProps();
        JSONObject jsonObject = JSONUtil.parseObj(ceDevProps);
        List<String> correlTableMeter = (List<String>) jsonObject.get("correlTableMeter");
        if (CollectionUtil.isNotEmpty(correlTableMeter)) {
            // 调用iot接口获取表记信息
            R<List<GmDevMeter>> devMeterIdList = remoteIotService.getDevMeterIdList(correlTableMeter);
            log.info("调用iot接口获取表记信息:{}", devMeterIdList.getCode());
            if (CollectionUtil.isNotEmpty(devMeterIdList.getData())) {
                List<GmDevMeter> data = devMeterIdList.getData();
                // 使用map方法，简化映射
                List<String> devMeterNos = data
                        .stream()
                        .map(GmDevMeter::getDevMeterNo)
                        .collect(Collectors.toList());
                jsonObject.set("correlTableMeterName", devMeterNos);
            }
        }

        CePartVo cePartVo = new CePartVo();
        BeanUtil.copyProperties(cePartDto, cePartVo);
        cePartVo.setCeResourceProps(jsonObject);
        return cePartVo;
    }

    @Override
    public CePartPageDto listPagedEnergyRegions(EnergyRegionPageRequest energyRegionPageRequest) {
        CePartPageDto cePartPageDto = new CePartPageDto();
        Page<CePartDto> page = new Page<>(energyRegionPageRequest.getPageNumber(), energyRegionPageRequest.getPageSize());
        IPage<CePartDto> cePartDtoIPage = cePartMapper.listPagedEnergyRegions(page);
        // 数据集合
        List<CePartDto> records = cePartDtoIPage.getRecords();
        cePartPageDto.setCePartDtoList(records);
        // 总数
        long total = cePartDtoIPage.getTotal();
        cePartPageDto.setTotal(total);
        return cePartPageDto;
    }
}




