package com.gaea.iesms.bm.archive.service.impl;


import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gaea.iesms.bm.archive.mapper.CeResourceDetailMapper;
import com.gaea.iesms.bm.archive.model.request.ceResourceDetail.AddCeResourceDetailRequest;
import com.gaea.iesms.bm.archive.model.request.ceResourceDetail.GetCeResourceDetailRequest;
import com.gaea.iesms.bm.archive.model.request.ceResourceDetail.GetLowerCeResSortRequest;
import com.gaea.iesms.bm.archive.model.request.ceResourceDetail.UpdateCeResourceDetailRequest;
import com.gaea.iesms.bm.archive.model.response.dto.ceResourceDetail.CeResourceDetailDto;
import com.gaea.iesms.bm.archive.model.response.vo.ceResourceDetail.LowerCeResSortVo;
import com.gaea.iesms.bm.archive.service.CeResourceDetailService;
import com.gaea.iesms.core.model.entity.archive.CeResourceDetail;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Administrator
 * @description 针对表【ce_resource_detail(用能资源树明细 )】的数据库操作Service实现
 * @createDate 2023-04-11 14:35:44
 */
@Service
public class CeResourceDetailServiceImpl extends ServiceImpl<CeResourceDetailMapper, CeResourceDetail>
        implements CeResourceDetailService {

    @Resource
    private CeResourceDetailMapper ceResourceDetailMapper;

    @Override
    public Integer addCeResourceDetail(AddCeResourceDetailRequest addCeResourceDetailRequest) {
        CeResourceDetail ceResourceDetail = new CeResourceDetail();
        BeanUtils.copyProperties(addCeResourceDetailRequest, ceResourceDetail);
        return ceResourceDetailMapper.insert(ceResourceDetail);
    }

    @Override
    public Integer removeCeResourceDetail(String id) {
        return ceResourceDetailMapper.deleteById(id);
    }

    @Override
    public Integer updateCeResourceDetail(UpdateCeResourceDetailRequest updateCeResourceDetailRequest) {
        CeResourceDetail ceResourceDetail = new CeResourceDetail();
        BeanUtils.copyProperties(updateCeResourceDetailRequest, ceResourceDetail);
        return ceResourceDetailMapper.updateById(ceResourceDetail);
    }

    @Override
    public CeResourceDetailDto getCeResourceDetailById(String id) {
        CeResourceDetail ceResourceDetail = ceResourceDetailMapper.selectById(id);
        CeResourceDetailDto ceResourceDetailDto = new CeResourceDetailDto();
        BeanUtils.copyProperties(ceResourceDetail, ceResourceDetailDto);
        return ceResourceDetailDto;
    }

    @Override
    public List<CeResourceDetailDto> querySubResourcesBySuperResource(GetCeResourceDetailRequest getCeResourceDetailRequest) {

        LambdaQueryWrapper<CeResourceDetail> ceResourceDetailLambdaQueryWrapper = new LambdaQueryWrapper<>();
        ceResourceDetailLambdaQueryWrapper
                .eq(CeResourceDetail::getTreeId, getCeResourceDetailRequest.getTreeId())
                .eq(getCeResourceDetailRequest.getSupperCeResClass() != null, CeResourceDetail::getSupperCeResClass, getCeResourceDetailRequest.getSupperCeResClass())
                .eq(getCeResourceDetailRequest.getLowerCeResClass() != null, CeResourceDetail::getLowerCeResClass, getCeResourceDetailRequest.getLowerCeResClass())
                .eq(StrUtil.isNotEmpty(getCeResourceDetailRequest.getSupperCeResSortNo()), CeResourceDetail::getSupperCeResSortNo, getCeResourceDetailRequest.getSupperCeResSortNo())
                .eq(StrUtil.isNotEmpty(getCeResourceDetailRequest.getLowerCeResType()), CeResourceDetail::getLowerCeResType, getCeResourceDetailRequest.getLowerCeResType());
        List<CeResourceDetail> ceResourceDetails = ceResourceDetailMapper.selectList(ceResourceDetailLambdaQueryWrapper);

        List<CeResourceDetailDto> list = new ArrayList<>();
        ceResourceDetails.forEach(item -> {
            CeResourceDetailDto ceResourceDetailDto = new CeResourceDetailDto();
            BeanUtils.copyProperties(item, ceResourceDetailDto);
            list.add(ceResourceDetailDto);
        });
        return list;
    }

    @Override
    public List<LowerCeResSortVo> getLowerCeResSort(GetLowerCeResSortRequest request) {
        return ceResourceDetailMapper.getLowerCeResSort(request);
    }
}




