package com.gaea.iesms.bm.archive.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gaea.iesms.bm.archive.model.request.ceDeivce.CeDeviceByResClassAndTypeQueryRequest;
import com.gaea.iesms.bm.archive.model.request.ceDeivce.CeDevicePageRequest;
import com.gaea.iesms.bm.archive.model.response.dto.ceDevice.CeDeviceDto;
import com.gaea.iesms.bm.archive.model.response.dto.ceDevice.IntervalsWithParentInfoDto;
import com.gaea.iesms.bm.archive.model.response.dto.ceResource.EnergyResourceTypeDto;
import com.gaea.iesms.core.model.entity.archive.CeDevice;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author JIE
 * @description 针对表【ce_device(用能设备 用能资源子表)】的数据库操作Mapper
 * @createDate 2023-02-20 09:44:39
 * @Entity com.gaea.iesms.core.model.entity.archive.CeDevice
 */
@Mapper
public interface CeDeviceMapper extends BaseMapper<CeDevice> {
    /**
     * 查询所有设备档案
     *
     * @param: page  分页参数
     * @return: com.baomidou.mybatisplus.core.metadata.IPage<com.gaea.iesms.bm.archive.model.response.dto.ceDevice.CeDeviceDto>
     * @author JIE
     * @date: 2024/2/26 11:48
     */
    IPage<CeDeviceDto> listCeDevcePageDto(@Param("param") CeDevicePageRequest request,
                                          @Param("page") Page<CeDeviceDto> page);


    /**
     * 根据用能资源类别和用能资源类型 获取用能设备
     *
     * @return 用能设备集合
     * @author: JIE
     * @date: 2023/3/22 15:26
     */
    List<EnergyResourceTypeDto> queryCeDeviceByCeResClassAndCeResType(CeDeviceByResClassAndTypeQueryRequest request);

    /**
     * 搜索间隔
     *
     * @param ceCustId 用户ID
     * @param keyWord  关键字
     * @return List<IntervalVo>
     * @author JIE
     * @date: 2023/11/24 19:23
     */
    List<IntervalsWithParentInfoDto> searchIntervals(@Param("ceCustId") Long ceCustId,
                                                     @Param("orgNo") String orgNo,
                                                     @Param("keyWord") String keyWord);
}




