package com.gaea.iesms.bm.archive.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.gaea.iesms.bm.archive.model.request.ceResource.IsNumberExistsRequest;
import com.gaea.iesms.bm.archive.model.request.ceResource.SelectCeResourceByClassAndTypeRequest;
import com.gaea.iesms.bm.archive.model.response.vo.ResourceVo;
import com.gaea.iesms.core.model.entity.archive.CeResource;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 针对表【ce_resource(用能资源 )】的数据库操作Mapper
 *
 * @author JIE
 * @version 1.0
 * @date 2024/1/31 10:38
 */
@Mapper
public interface CeResourceMapper extends BaseMapper<CeResource> {

    /**
     * 根据 用能资源类别 和  用能资源类型 获取用能资源信息
     *
     * @return: 用能资源信息
     * @author: JIE
     * @date: 2023/4/12 15:41
     */
    List<CeResource> selectCeResourceByClassAndType(SelectCeResourceByClassAndTypeRequest request);

    /**
     * 查询用能资源编号是否重复
     *
     * @param request 请求参数
     * @return > 0 就是有重复
     * @author JIE
     * @date: 2023/11/27 11:03
     */
    int isNumberExists(IsNumberExistsRequest request);
}




